/**
 * @file	dd2.h
 * @brief	DirectDraw2 `NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <ddraw.h>
#include "cmndraw.h"

/**
 * @brief DirectDraw2 class
 */
class DD2Surface
{
public:
	DD2Surface();
	~DD2Surface();

	bool Create(HWND hWnd, int nWidth, int nHeight);
	void Release();
	CMNVRAM* Lock();
	void Unlock();
	void Blt(const POINT* pt, const RECT* lpRect = NULL);
	UINT16 GetPalette16(RGB32 pal) const;

protected:
	HWND					m_hWnd;				/*!< EBhE nh */
	LPDIRECTDRAW			m_pDDraw;			/*!< DirectDraw CX^X */
	LPDIRECTDRAW2			m_pDDraw2;			/*!< DirectDraw2 CX^X */
	LPDIRECTDRAWSURFACE		m_pPrimarySurface;	/*!< vC} T[tFX */
	LPDIRECTDRAWSURFACE		m_pBackSurface;		/*!< obN T[tFX */
	LPDIRECTDRAWCLIPPER		m_pClipper;			/*!< Nbp[ */
	LPDIRECTDRAWPALETTE		m_pPalette;			/*!< pbg */
	RGB32					m_pal16;			/*!< 16BPP}XN */
	UINT8					m_r16b;				/*!< B Vtg */
	UINT8					m_l16r;				/*!< R Vtg */
	UINT8					m_l16g;				/*!< G Vtg */
	CMNVRAM					m_vram;				/*!< VRAM */
	PALETTEENTRY			m_pal[256];			/*!< pbg */
};
