config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.fail2ban.new:
if [ -e etc/rc.d/rc.fail2ban ]; then
  cp -a etc/rc.d/rc.fail2ban etc/rc.d/rc.fail2ban.new.incoming
  cat etc/rc.d/rc.fail2ban.new > etc/rc.d/rc.fail2ban.new.incoming
  mv etc/rc.d/rc.fail2ban.new.incoming etc/rc.d/rc.fail2ban.new
fi

# make directory for socket and pid file
if [ ! -d var/run/fail2ban ]; then
	mkdir -p var/run/fail2ban
fi

config etc/rc.d/rc.fail2ban.new
config etc/logrotate.d/fail2ban.new
