/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Extended for svgalib by Harm Hanemaayer and Hartmut Schirmer */

#ifndef VGA_H
#define VGA_H

#ifdef __cplusplus
extern "C" {
#endif

#define TEXT 	     0		/* Compatible with VGAlib v1.2 */
#define G320x200x16  1
#define G640x200x16  2
#define G640x350x16  3
#define G640x480x16  4
#define G320x200x256 5
#define G320x240x256 6
#define G320x400x256 7
#define G360x480x256 8
#define G640x480x2   9

#define G640x480x256 10
#define G800x600x256 11
#define G1024x768x256 12

#define G1280x1024x256 13	/* Additional modes. */

#define G320x200x32K 14
#define G320x200x64K 15
#define G320x200x16M 16
#define G640x480x32K 17
#define G640x480x64K 18
#define G640x480x16M 19
#define G800x600x32K 20
#define G800x600x64K 21
#define G800x600x16M 22
#define G1024x768x32K 23
#define G1024x768x64K 24
#define G1024x768x16M 25
#define G1280x1024x32K 26
#define G1280x1024x64K 27
#define G1280x1024x16M 28

#define G800x600x16 29
#define G1024x768x16 30
#define G1280x1024x16 31

#define G720x348x2 32		/* Hercules emulation mode */

#define G320x200x16M32 33	/* 32-bit per pixel modes. */
#define G640x480x16M32 34
#define G800x600x16M32 35
#define G1024x768x16M32 36
#define G1280x1024x16M32 37

#define __GLASTMODE G1280x1024x16M32
#define GLASTMODE vga_lastmodenumber()

extern int vga_setmode(int mode);
extern int vga_hasmode(int mode);
extern int vga_setflipchar(int c);

extern int vga_clear();
extern int vga_flip();

extern int vga_getxdim();
extern int vga_getydim();
extern int vga_getcolors();

extern int vga_setpalette(int index, int red, int green, int blue);
extern int vga_getpalette(int index, int *red, int *green, int *blue);
extern int vga_setpalvec(int start, int num, int *pal);
extern int vga_getpalvec(int start, int num, int *pal);

extern int vga_screenoff();
extern int vga_screenon();

extern int vga_setcolor(int color);
extern int vga_drawpixel(int x, int y);
extern int vga_drawline(int x1, int y1, int x2, int y2);
extern int vga_drawscanline(int line, unsigned char* colors);
extern int vga_drawscansegment(unsigned char* colors, int x, int y, int length);

extern int vga_getch();

extern int vga_dumpregs();


/* Extensions to VGAlib v1.2: */

/* blit flags */
#define HAVE_BITBLIT 1
#define HAVE_FILLBLIT 2
#define HAVE_IMAGEBLIT 4

/* other flags */
#define HAVE_RWPAGE 1		/* vga_setreadpage() / vga_setwritepage() available */
#define IS_INTERLACED 2		/* mode is interlaced */
#define IS_MODEX 4		/* ModeX style 256 colors */
#define IS_DYNAMICMODE 8	/* Dynamic defined mode */
#define CAPABLE_LINEAR 16	/* Can go to linear addressing mode. */
#define IS_LINEAR 32		/* Linear addressing enabled. */
#define EXT_INFO_AVAILABLE 64	/* Returned modeinfo contains valid extended fields */

typedef struct {
	int width;
	int height;
	int bytesperpixel;
	int colors;
	int linewidth;		/* scanline width in bytes */
	int maxlogicalwidth;	/* maximum logical scanline width */
	int startaddressrange;	/* changeable bits set */
	int maxpixels;		/* video memory / bytesperpixel */
	int haveblit;		/* mask of blit functions available */
	int flags;		/* other flags */

	/* Extended fields: */

	int chiptype;		/* Chiptype detected */
	int memory;		/* videomemory in KB */
	int linewidth_unit;	/* Use only a multiple of this as parameter for set_logicalwidth and
				   set_displaystart */
	char *linear_aperture;	/* points to mmap secondary mem aperture of card (NULL if unavailable) */
	int aperture_size;	/* size of aperture in KB if size>=videomemory. 0 if unavail */
	void (*set_aperture_page)(int page);
				/* if aperture_size<videomemory select a memory page */
	void *extensions;	/* points to copy of eeprom for mach32 */
				/* depends from actual driver/chiptype.. etc. */
} vga_modeinfo;

extern vga_modeinfo *vga_getmodeinfo( int mode );
extern int vga_getdefaultmode();
extern int vga_getcurrentmode();
extern int vga_getcurrentchipset();
extern char *vga_getmodename( int mode );
extern int vga_getmodenumber( char *name );
extern int vga_lastmodenumber(void);

extern unsigned char *graph_mem;
extern unsigned char *vga_getgraphmem();

extern void vga_setpage( int p );
extern void vga_setreadpage( int p );
extern void vga_setwritepage( int p );
extern void vga_setlogicalwidth( int w );
extern void vga_setdisplaystart( int a );
extern void vga_waitretrace();
extern int vga_claimvideomemory( int n );
extern void vga_disabledriverreport();
extern int vga_setmodeX();
extern void vga_init();
extern int vga_getmousetype();
extern int vga_getmonitortype();
extern void vga_setmousesupport( int s );
extern void vga_lockvc();
extern void vga_unlockvc();
extern int vga_getkey();
extern void vga_runinbackground( int s );
extern int vga_oktowrite();
extern void vga_copytoplanar256( unsigned char *virtualp, int pitch,
	int voffset, int vpitch, int w, int h );
extern void vga_copytoplanar16( unsigned char *virtualp, int pitch,
	int voffset, int vpitch, int w, int h );
extern void vga_setlinearaddressing();
extern void vga_safety_fork(void (*shutdown_routine)(void));


#ifdef EGA	/* Kernel headers may define this. */
#undef EGA
#endif

#define UNDEFINED	0
#define VGA		1
#define ET4000		2
#define CIRRUS		3
#define TVGA8900	4 
#define OAK		5
#define EGA		6
#define S3		7
#define ET3000		8
#define MACH32		9

				/* Hor. sync: */
#define MON640_60	0	/* 31.5 KHz (standard VGA) */
#define MON800_56	1	/* 35.1 KHz (old SVGA) */
#define MON1024_43I	2	/* 35.5 KHz (low-end SVGA, 8514) */
#define MON800_60	3	/* 37.9 KHz (SVGA) */
#define MON1024_60	4	/* 48.3 KHz (SVGA non-interlaced) */
#define MON1024_70	5	/* 56.0 KHz (SVGA high frequency) */
#define MON1024_72	6

extern void vga_setchipset( int c );
extern void vga_setchipsetandfeatures( int c, int par1, int par2 );
extern void vga_gettextfont( void *font );
extern void vga_puttextfont( void *font );
extern void vga_settextmoderegs( void *regs );
extern void vga_gettextmoderegs( void *regs );

extern int vga_white(); 
extern int vga_setegacolor( int c );
extern int vga_setrgbcolor( int r, int g, int b );

extern void vga_bitblt( int srcaddr, int destaddr, int w, int h, int pitch );
extern void vga_imageblt( void *srcaddr, int destaddr, int w, int h, int pitch );
extern void vga_fillblt( int destaddr, int w, int h, int pitch, int c );
extern void vga_hlinelistblt( int ymin, int n, int *xmin, int *xmax, int pitch, int c );

#ifdef __cplusplus
}
#endif

#endif /* VGA_H */

