#ifndef _RTTY_H
#define _RTTY_H

#include "cmplx.h"
#include "trx.h"

#define	SampleRate	8000
#define	MaxSymLen	1024

typedef enum {
	RTTY_RX_STATE_IDLE = 0,
	RTTY_RX_STATE_START,
	RTTY_RX_STATE_DATA,
	RTTY_RX_STATE_PARITY,
	RTTY_RX_STATE_STOP,
	RTTY_RX_STATE_STOP2
} rtty_rx_state_t;

typedef enum {
	PARITY_NONE = 0,
	PARITY_EVEN,
	PARITY_ODD,
	PARITY_ZERO,
	PARITY_ONE
} parity_t;

struct rtty {
	/*
	 * Common stuff
	 */
	double shift;
	int symbollen;
	int nbits;
	parity_t parity;
	int stoplen;
	int reverse;
	int msb;

	double phaseacc;

	/*
	 * RX related stuff
	 */
	struct filter *hilbert;
	struct fftfilt *fftfilt;

	double pipe[MaxSymLen];
	unsigned int pipeptr;

	double bbfilter[MaxSymLen];
	unsigned int filterptr;

	rtty_rx_state_t rxstate;

	int counter;
	int bitcntr;
	int rxdata;

	double prevsymbol;

	int rxmode;

	/*
	 * TX related stuff
	 */
	int txmode;
	int preamble;
};

/* in rtty.c */
extern void rtty_init(struct trx *trx);

/* in rttyrx.c */
extern int rtty_rxprocess(struct trx *trx, float *buf, int len);

/* in rttytx.c */
extern int rtty_txprocess(struct trx *trx);

#endif
