%define ver 1.1.4
%define prefix	/usr

Summary: Run-time library to control radio transcievers and receivers.
Name: hamlib
Version: %ver
Release: 1
Copyright: LGPL
Group: Ham/Libraries
Packager: Stephane Fillod <fillods@users.sourceforge.net>
Source: ftp://ftp.sourceforge.net/pub/sourceforge/hamlib/hamlib-%{ver}.tar.gz
BuildRoot: /tmp/hamlib-%{ver}-buildroot
URL: http://hamlib.sourceforge.net
BuildRequires: binutils >= 2.9.4, gcc >= 2.95, glibc-devel >= 2.1
BuildRequires: /bin/sh, fileutils, findutils, flex
BuildRequires: gzip, make >= 3.77, patch >= 2.5, rpm >= 3.0, sed
BuildRequires: textutils
BuildRequires: /bin/sh, automake >= 1.4, libtool >= 1.4, fileutils, findutils

%changelog

* Wed Jan 15 2003 Joop Stakenborg
- Fix the spec file for 1.1.4CVS
- 'make rpm' should work now

* Thu Jun 17 2002 Stephane Fillod
- Added rotator support
- Added RPC daemon, hamlib.m4
- Upstream version 1.1.3

* Mon Jul 18 2001 Stephane Fillod
- Made initial "working" SPEC file


%description
 Most recent amateur radio transceivers allow external control of their
 functions through a computer interface. Unfortunately, control commands are
 not always consistent across a manufacturer's product line and each
 manufacturer's product line differs greatly from its competitors.
 .
 This library addresses that issue by providing a standardised programming
 interface that applications can talk to and translating that into the
 appropriate commands required by the radio in use.
 .
 This package provides the run-time form of the library. If you wish to
 develop software using this library you need the 'hamlib-devel' package.
 .
 Also included in the package is a simple radio control program 'rigctl',
 which let one control a radio transceiver or receiver, either from
 command line interface or in a text-oriented interactive interface.

%package devel
Summary: Development library to control radio transcievers and receivers.
Group: Development/Libraries
Requires: hamlib

%description devel
 Most recent amateur radio transceivers allow external control of their
 functions through a computer interface. Unfortunately, control commands are
 not always consistent across a manufacturer's product line and each
 manufacturer's product line differs greatly from its competitors.
 .
 This library addresses that issue by providing a standardised programming
 interface that applications can talk to and translating that into the
 appropriate commands required by the radio in use.
 .
 This package provides the development library. If you wish to run applications
 developed using this library you'll need the 'hamlib' package.

#%package c++
#Summary: Hamlib radio control library C++ binding
#Group: Development/Libraries
#Requires: hamlib

#%description c++
#C++ Binding.

#%package c++-devel
#Summary: Hamlib radio control library C++ binding headers and static libs
#Group: Development/Libraries
#Requires: hamlib, hamlib-devel

#%description c++-devel
#This package contains all of the headers and the static libraries 
#for C++ binding of Hamlib.

#You'll only need this package if you are doing development.

#%package perl
#Summary: Hamlib radio control library Perl binding
#Group: Development/Libraries
#Requires: hamlib
#
#%description perl
#Perl Binding.

%prep
%setup
%build

./configure --prefix=%prefix
make CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" all

%install
rm -rf $RPM_BUILD_ROOT
(umask 077 && mkdir -p $RPM_BUILD_ROOT)
chmod go= $RPM_BUILD_ROOT

make prefix="$RPM_BUILD_ROOT%{prefix}" "INSTALL_PROGRAM_ARGS=-s" install

chmod 644 $RPM_BUILD_ROOT%{prefix}/lib/*.la
#strip $RPM_BUILD_ROOT%{prefix}/lib/*-%{version}.so


%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig


%files
%defattr(644, root, root, 755)
%doc COPYING

#%doc doc/*.html
#%doc doc/*.sgml
#%doc doc/*.txt

%defattr(755, root, root, 755)
%{prefix}/lib/libhamlib-%{ver}.so.1
%{prefix}/lib/libhamlib-%{ver}.so.1.0.0
%{prefix}/lib/libhamlib.la
%{prefix}/lib/hamlib-alinco.so
%{prefix}/lib/hamlib-alinco.la
%{prefix}/lib/hamlib-aor.so
%{prefix}/lib/hamlib-aor.la
%{prefix}/lib/hamlib-drake.so
%{prefix}/lib/hamlib-drake.la
%{prefix}/lib/hamlib-dummy.so
%{prefix}/lib/hamlib-dummy.la
%{prefix}/lib/hamlib-easycomm.so
%{prefix}/lib/hamlib-easycomm.la
%{prefix}/lib/hamlib-fodtrack.so
%{prefix}/lib/hamlib-fodtrack.la
%{prefix}/lib/hamlib-icom.so
%{prefix}/lib/hamlib-icom.la
%{prefix}/lib/hamlib-jrc.so
%{prefix}/lib/hamlib-jrc.la
%{prefix}/lib/hamlib-kachina.so
%{prefix}/lib/hamlib-kachina.la
%{prefix}/lib/hamlib-kenwood.so
%{prefix}/lib/hamlib-kenwood.la
%{prefix}/lib/hamlib-pcr.so
%{prefix}/lib/hamlib-pcr.la
%{prefix}/lib/hamlib-rotorez.so
%{prefix}/lib/hamlib-rotorez.la
%{prefix}/lib/hamlib-rpcrig.so
%{prefix}/lib/hamlib-rpcrig.la
%{prefix}/lib/hamlib-rpcrot.so
%{prefix}/lib/hamlib-rpcrot.la
%{prefix}/lib/hamlib-tentec.so
%{prefix}/lib/hamlib-tentec.la
%{prefix}/lib/hamlib-uniden.so
%{prefix}/lib/hamlib-uniden.la
%{prefix}/lib/hamlib-winradio.so
%{prefix}/lib/hamlib-winradio.la
%{prefix}/lib/hamlib-yaesu.so
%{prefix}/lib/hamlib-yaesu.la
%{prefix}/bin/rigctl
%{prefix}/sbin/rpc.rigd
%{prefix}/man/man1/rigctl.1.gz
%{prefix}/man/man8/rpc.rigd.8.gz
%{prefix}/bin/rotctl
%{prefix}/sbin/rpc.rotd
%{prefix}/man/man1/rotctl.1.gz
%{prefix}/man/man8/rpc.rotd.8.gz

%files devel
%defattr(644, root, root, 755)

%{prefix}/include/hamlib/rig.h
%{prefix}/include/hamlib/rig_dll.h
%{prefix}/include/hamlib/riglist.h
%{prefix}/include/hamlib/rotator.h
%{prefix}/include/hamlib/rotlist.h
%{prefix}/share/aclocal/hamlib.m4
%{prefix}/lib/pkgconfig/hamlib.pc
%{prefix}/lib/libhamlib.a
%{prefix}/lib/libhamlib.so
%{prefix}/lib/hamlib-alinco.a
%{prefix}/lib/hamlib-aor.a
%{prefix}/lib/hamlib-drake.a
%{prefix}/lib/hamlib-dummy.a
%{prefix}/lib/hamlib-easycomm.a
%{prefix}/lib/hamlib-fodtrack.a
%{prefix}/lib/hamlib-icom.a
%{prefix}/lib/hamlib-jrc.a
%{prefix}/lib/hamlib-kachina.a
%{prefix}/lib/hamlib-kenwood.a
%{prefix}/lib/hamlib-pcr.a
%{prefix}/lib/hamlib-rotorez.a
%{prefix}/lib/hamlib-rpcrig.a
%{prefix}/lib/hamlib-rpcrot.a
%{prefix}/lib/hamlib-tentec.a
%{prefix}/lib/hamlib-uniden.a
%{prefix}/lib/hamlib-winradio.a
%{prefix}/lib/hamlib-yaesu.a

#%files c++
#%defattr(755, root, root, 755)
#%{prefix}/lib/libhamlib++-%{version}.so


#%files c++-devel
#%defattr(644, root, root, 755)

#%{prefix}/include/hamlib/rigclass.h
#%{prefix}/include/hamlib/rotclass.h

#%{prefix}/share/aclocal/hamlib++.m4
#%{prefix}/lib/libhamlib++.a
#%{prefix}/lib/libhamlib++.la

#%files perl
#%defattr(755, root, root, 755)
#/usr/local/lib/perl/5.6.1/Hamlib.pm
#%dir /usr/local/lib/perl/5.6.1/auto/Hamlib
#%doc /usr/local/man/man3/Hamlib.3pm

