/*
 * Copyright (C) 2001-2004 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: globals.h,v 1.22.2.2 2005/07/06 19:13:44 dsalt Exp $
 *
 * global variables for lazy programmers... :>
 */

#ifndef HAVE_GLOBALS_H
#define HAVE_GLOBALS_H

/*
#define EXP_STUFF
*/

#include "config.h"
#include "i18n.h"

#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <xine.h>

#include "script_engine.h"
#include "infobar.h"

#include "defs.h"

extern GtkWidget      *app;
extern GtkWidget      *gtv; /* GtkVideo widget */
extern GtkWidget      *menubar, *popup_menu;
extern infobar_t      *bar;
extern pthread_mutex_t engine_lock;
extern GdkPixbuf      *gxine_logo;
extern GtkMenuShell   *media_menu[2],
		      *vis_menu[2];
extern GtkCheckMenuItem *fullscreen_menu_item[2],
			*auto_resize_menu_item[2],
			*auto_rescale_menu_item[2],
			*deinterlace_menu_item[2],
			*pp_video_menu_item[2],
			*pp_audio_menu_item[2],
			*toolbar_item[3][2];
extern GSList         *aspect_menu_items[2];
extern int             verbosity;
extern xine_t         *xine;
extern xine_stream_t  *stream;
extern se_t           *gse; /* global script engine */
extern gchar *plugindir, *bindir, *logodir, *pixmapdir, *icondir, *miscdir;
extern char           *audio_driver_id;
extern char           *video_driver_id;
extern xine_audio_port_t *audio_port;
extern xine_video_port_t *video_port;

#define MAX_MRL_LEN 1024

/* used in key event handlers for filtering out numlock etc. */
#define GXINE_MODIFIER_MASK \
  (GDK_SHIFT_MASK | GDK_CONTROL_MASK | \
   GDK_MOD1_MASK | GDK_MOD3_MASK | GDK_MOD4_MASK)

#define CONFIG_DATA_NONE ((void *)1)

/* GTK+ 2.6 compatibility */
#ifdef GXINE_GTK_COMPAT
# define GTK_COMPAT_2_6(NEWER,OLDER) \
    (gtk_binary_age >= 600 ? (NEWER) : (OLDER))
#else /* compatibility not requested */
# if GTK_CHECK_VERSION(2,6,0)	/* 2.6 or later */
#  define GTK_COMPAT_2_6(NEWER,OLDER) (NEWER)
# else				/* 2.4 or earlier */
#  define GTK_COMPAT_2_6(NEWER,OLDER) (OLDER)
# endif
#endif
#define GTK_TEST_COMPAT_2_6 (GTK_COMPAT_2_6 (TRUE, FALSE))

/* GTK+ 2.4 is the preferred version */

/* GTK+ 2.2 compatibility */
#ifdef GXINE_GTK_COMPAT
# define GTK_COMPAT_CALL(FUNC,...) \
  do { if (FUNC) (FUNC)(__VA_ARGS__); } while (0)
void gtk_window_set_keep_above () __attribute__ ((weak));
void gtk_window_set_default_icon () __attribute__ ((weak));
void gtk_window_set_accept_focus () __attribute__ ((weak));
gboolean gtk_window_activate_key () __attribute__ ((weak));
# define gtk_window_set_keep_above(...) \
  GTK_COMPAT_CALL(gtk_window_set_keep_above,__VA_ARGS__)
# define gtk_window_set_default_icon(...) \
  GTK_COMPAT_CALL(gtk_window_set_default_icon,__VA_ARGS__)
# define gtk_window_set_accept_focus(...) \
  GTK_COMPAT_CALL(gtk_window_set_accept_focus,__VA_ARGS__)
#else /* compatibility not requested */
# if GTK_CHECK_VERSION(2,4,0)	/* 2.4 or later */
# else				/* 2.2 */
#  define gtk_window_set_keep_above(...)
#  define gtk_window_set_default_icon(...)
#  define gtk_window_set_accept_focus(...)
#  define gtk_window_activate_key(...) (0)
# endif
#endif

#endif
