 /***************************************************************************
                          main.cpp  -  description
                             -------------------
    copyright            : (C) 1997-2000 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <iostream>

#include <qvariant.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstandarddirs.h>

#include "ksvapplication.h"
#include "ksv_core.h"
#include "ksv_conf.h"
#include "ksvconfigwizard.h"
#include "TopWidget.h"

// copyright notice
#include "version.h"

using namespace std;

static const char copyright[] = "SysV-Init Editor " KSYSV_VERSION_STRING " Copyright  1997-2000 Peter Putzer.";
static const char license []  = "All rights reserved. Released under the GNU General Public License (GPL).";

#if (defined(DEBUG) && !(defined(NDEBUG) || defined(NO_DEBUG)))
#define KSYSV_DEBUG(x)  x
#else
#define KSYSV_DEBUG(x)  do { } while (0)
#endif

static void myMessageOutput( QtMsgType type, const char *msg )
{
  switch ( type ) {
  case QtDebugMsg:
    KSYSV_DEBUG(cerr << "Debug: " << msg << endl);
    break;
  case QtWarningMsg:
    KSYSV_DEBUG(cerr << "Warning: " << msg << endl);
    break;
  case QtFatalMsg:
    cerr << "Fatal: " << msg << endl;
    abort(); // dump core on purpose
  }
}

int main( int argc, char **argv ) {
  // install own message handler that ignores debug-msg when DEBUG is not defined
  qInstallMsgHandler(myMessageOutput);

  cout << copyright << endl << license << endl << endl;

  KAboutData about("ksysv", I18N_NOOP("SysV-Init Editor"), KSYSV_VERSION_STRING,
				   I18N_NOOP ("An editor for Sys-V like init configurations."),
				   KAboutData::License_GPL,
				   "Copyright  1997-2000, Peter Putzer.",
				   I18N_NOOP ("An editor for SysV-style init configuration, similar to Red Hat's\n" \
                              "\"tksysv\", but SysV-Init Editor allows drag-and-drop, as well as\n" \
                              "keyboard use."),
				   "http://eclipt.uni-klu.ac.at/projects/ksysv");
  about.addAuthor ("Peter Putzer", I18N_NOOP("Main developer"), "putzer@kde.org");
  ksv::about = &about;

  KCmdLineArgs::init(argc, argv, &about);
  KUniqueApplication::addCmdLineOptions ();

  if (!KUniqueApplication::start()) {
	cerr << "SysV-Init Editor is already running!" << endl;
    return -1;
  }

  KSVApplication app;

  // to signal errors to scripts... well its cleaner at least
  int returnValue = 1;

  // session-management
  if (kapp->isRestored())
	RESTORE(KSVTopLevel)
  else
    {
      KSVConfig* conf = KSVConfig::self();
      if (!conf->isConfigured())
        {
          KSVConfigWizard* w = new KSVConfigWizard(0, "ConfigWizard", true);
          w->exec();

          conf->setConfigured(true);
          conf->setRunlevelPath (w->runlevelPath());
          conf->setScriptPath (w->servicesPath());
          conf->writeSettings();
        }

      KSVTopLevel* top = new KSVTopLevel();
      top->show();
    }
  // end session-management

  returnValue = app.exec();

  return -returnValue;
}
