/***************************************************************************
                          reportview.h  -  description
                             -------------------
    begin                : Sun Oct 15 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REPORTVIEW_H
#define REPORTVIEW_H

#include <kdialogbase.h>
#include <qstringlist.h>

#include <dcopref.h>

class KHTMLPart;
class DCOPRef;

/**This is the main report generated for the user.
  *@author Ian Reinhart Geiser
  */

class reportView : public KDialogBase {
    Q_OBJECT

public:
    reportView(QString reportLocation);
    ~reportView();

    void getWeatherData();
    void render();

protected:
    DCOPReply callDCOP( const QString &name );

private:
    DCOPRef *m_weatherService;
    KHTMLPart *m_reportView;
    QString m_locationCode;
    QString m_locationName;
    QString m_temp;
    QString m_dewPoint;
    QString m_relHumidity;
    QString m_heatIndex;
    QString m_windChill;
    QString m_time;
    QString m_pressure;
    QString m_wind;
    QString m_sunRiseTime;
    QString m_sunSetTime;
    QString m_date;
    QString m_icon;
    QStringList m_cover;
    QStringList m_weather;
};

#endif
