/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;

public final class AccessControlContext {
    private ProtectionDomain[] protectionDomain;
    private DomainCombiner combiner;

    public AccessControlContext(ProtectionDomain[] context) {
        int k;
        int i;
        int count = context.length;
        int count2 = 0;
        int j = 0;
        for (i = 0; i < count; ++i) {
            for (k = 0; k < i && context[k] != this.protectionDomain[i]; ++k) {
            }
            if (k != i) continue;
            ++count2;
        }
        this.protectionDomain = new ProtectionDomain[count2];
        j = 0;
        for (i = 0; i < count2; ++i) {
            for (k = 0; k < i && context[k] != this.protectionDomain[i]; ++k) {
            }
            if (k != i) continue;
            this.protectionDomain[j++] = context[i];
        }
    }

    public AccessControlContext(AccessControlContext acc, DomainCombiner combiner) {
        this(acc.protectionDomain);
        this.combiner = combiner;
    }

    public DomainCombiner getDomainCombiner() {
        return this.combiner;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        for (int i = 0; i < this.protectionDomain.length; ++i) {
            if (!this.protectionDomain[i].implies(perm)) continue;
            return;
        }
        throw new AccessControlException("Permission not granted");
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessControlContext) {
            AccessControlContext acc = (AccessControlContext)obj;
            if (acc.protectionDomain.length != this.protectionDomain.length) {
                return false;
            }
            for (int i = 0; i < this.protectionDomain.length; ++i) {
                if (acc.protectionDomain[i] == this.protectionDomain[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.protectionDomain.length; ++i) {
            h ^= this.protectionDomain[i].hashCode();
        }
        return h;
    }
}

