/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    static final long serialVersionUID = -5677132037850737084L;
    private static final Object[] NO_LISTENERS = new Object[0];
    protected transient Object[] listenerList;

    private /* synthetic */ void finit$() {
        this.listenerList = NO_LISTENERS;
    }

    public EventListenerList() {
        this.finit$();
    }

    public void add(Class t, EventListener listener) {
        if (listener == null) {
            return;
        }
        if (!t.isInstance(listener)) {
            throw new IllegalArgumentException();
        }
        int oldLength = this.listenerList.length;
        Object[] newList = new Object[oldLength + 2];
        if (oldLength > 0) {
            System.arraycopy(this.listenerList, 0, newList, 0, oldLength);
        }
        newList[oldLength] = t;
        newList[oldLength + 1] = listener;
        this.listenerList = newList;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class t) {
        int result = 0;
        for (int i = 0; i < this.listenerList.length; i += 2) {
            if (t != this.listenerList[i]) continue;
            ++result;
        }
        return result;
    }

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public EventListener[] getListeners(Class c) {
        int count = this.getListenerCount(c);
        EventListener[] result = (EventListener[])Array.newInstance(c, count);
        int f = 0;
        for (int i = 0; i < this.listenerList.length; i += 2) {
            if (this.listenerList[i] != c) continue;
            result[f++] = (EventListener)this.listenerList[i + 1];
        }
        return result;
    }

    public void remove(Class t, EventListener listener) {
        if (listener == null) {
            return;
        }
        if (!t.isInstance(listener)) {
            throw new IllegalArgumentException();
        }
        Object[] oldList = this.listenerList;
        int oldLength = oldList.length;
        for (int i = 0; i < oldLength; i += 2) {
            Object[] newList;
            if (oldList[i] != t || oldList[i + 1] != listener) continue;
            if (oldLength == 2) {
                newList = NO_LISTENERS;
            } else {
                newList = new Object[oldLength - 2];
                if (i > 0) {
                    System.arraycopy(oldList, 0, newList, 0, i);
                }
                if (i < oldLength - 2) {
                    System.arraycopy(oldList, i + 2, newList, i, oldLength - 2 - i);
                }
            }
            this.listenerList = newList;
            return;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("EventListenerList: ");
        buf.append(this.listenerList.length / 2);
        buf.append(" listeners: ");
        for (int i = 0; i < this.listenerList.length; i += 2) {
            buf.append(" type ");
            buf.append(((Class)this.listenerList[i]).getName());
            buf.append(" listener ");
            buf.append(this.listenerList[i + 1]);
        }
        return buf.toString();
    }
}

