/*
  Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this library; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

#ifndef WIFICONFIG_H
#define WIFICONFIG_H

#include <qstring.h>
#include <qvaluelist.h>

class KConfig;
class KSimpleConfig;

class Key
{
  public:
    Key( const QString &key );
    Key();

    QString key() const { return m_key; }
    bool isString() const { return m_isString; }
    bool isValid() const { return !m_key.isEmpty(); }
    QString rawKey() const;

    void setKey( const QString &key );
    void setIsString( bool b ) { m_isString = b; }

  protected:
    QString m_key;
    bool m_isString;
};

typedef QValueList<Key> KeyList;

class IfConfig
{
  public:
    IfConfig();

    enum Speed { AUTO=0, M1, M2, M55, M6, M9, M11, M12, M18, M24, M36, M48, M54 };
    enum WifiMode { AdHoc=0, Managed, Repeater, Master, Secondary };
    enum PowerMode { AllPackets=0, UnicastOnly, MulticastOnly };
    enum CryptoMode { Open=0, Restricted };

    void load( KConfig *config, int i );
    void save( KConfig *config, int i );

    QString speedAsString();
    QString wifimodeAsString();
    QString cryptomodeAsString();
    QString powermodeAsString();
    int activeKeyId();
    Key activeKey();

    void speedFromString( const QString &s );
    void wifimodeFromString( const QString &s );
    void powermodeFromString( const QString &s );
    void cryptomodeFromString( const QString &s );

    QString m_networkName;
    WifiMode m_wifiMode;
    Speed m_speed;
    bool m_runScript;
    QString m_connectScript;

    bool m_useCrypto;
    CryptoMode m_cryptoMode;
    int m_activeKey;
    Key m_keys[ 4 ];

    bool m_pmEnabled;
    PowerMode m_pmMode;
    int m_sleepTimeout;
    int m_wakeupPeriod;
};

class WifiConfig
{
  public:
    static WifiConfig *instance();
    ~WifiConfig();

    void load();
    void save();

    IfConfig m_ifConfig[ 4 ];
    bool m_usePreset;
    int m_presetConfig;
    QString m_interface;

  private:
    WifiConfig();

    KSimpleConfig *m_config;

    static WifiConfig *m_instance;
};

#endif // WIFICONFIG_H
