/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStore {
    private static final String KEYSTORE_TYPE = "keystore.type";
    private String type;
    private Provider provider;
    private KeyStoreSpi keyStoreSpi;
    private boolean initialized = false;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.keyStoreSpi = keyStoreSpi;
        this.provider = provider;
        this.type = string;
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", (String)null);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreException(string + " not found");
        }
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", string2);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found");
        }
    }

    public static KeyStore getInstance(String string, Provider provider) throws KeyStoreException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", provider);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found");
        }
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(KeyStore.KEYSTORE_TYPE);
            }
        });
        if (string == null) {
            string = "jks";
        }
        return string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetKey(string, cArray);
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificateChain(string);
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificate(string);
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCreationDate(string);
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        if (key instanceof PrivateKey && (certificateArray == null || certificateArray.length == 0)) {
            throw new IllegalArgumentException("Private key must be accompanied by certificate chain");
        }
        this.keyStoreSpi.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetCertificateEntry(string, certificate);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineDeleteEntry(string);
    }

    public final Enumeration<String> aliases() throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineAliases();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineContainsAlias(string);
    }

    public final int size() throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineSize();
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineIsKeyEntry(string);
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineIsCertificateEntry(string);
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificateAlias(certificate);
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineStore(outputStream, cArray);
    }

    public final void store(LoadStoreParameter loadStoreParameter) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineStore(loadStoreParameter);
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(inputStream, cArray);
        this.initialized = true;
    }

    public final void load(LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(loadStoreParameter);
        this.initialized = true;
    }

    public final Entry getEntry(String string, ProtectionParameter protectionParameter) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        if (string == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetEntry(string, protectionParameter);
    }

    public final void setEntry(String string, Entry entry, ProtectionParameter protectionParameter) throws KeyStoreException {
        if (string == null || entry == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetEntry(string, entry, protectionParameter);
    }

    public final boolean entryInstanceOf(String string, Class<? extends Entry> clazz) throws KeyStoreException {
        if (string == null || clazz == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineEntryInstanceOf(string, clazz);
    }

    public static abstract class Builder {
        protected Builder() {
        }

        public abstract KeyStore getKeyStore() throws KeyStoreException;

        public abstract ProtectionParameter getProtectionParameter(String var1) throws KeyStoreException;

        public static Builder newInstance(final KeyStore keyStore, final ProtectionParameter protectionParameter) {
            if (keyStore == null || protectionParameter == null) {
                throw new NullPointerException();
            }
            if (!keyStore.initialized) {
                throw new IllegalArgumentException("KeyStore not initialized");
            }
            return new Builder(){
                private volatile boolean getCalled;

                public KeyStore getKeyStore() {
                    this.getCalled = true;
                    return keyStore;
                }

                public ProtectionParameter getProtectionParameter(String string) {
                    if (string == null) {
                        throw new NullPointerException();
                    }
                    if (!this.getCalled) {
                        throw new IllegalStateException("getKeyStore() must be called first");
                    }
                    return protectionParameter;
                }
            };
        }

        public static Builder newInstance(String string, Provider provider, File file, ProtectionParameter protectionParameter) {
            if (string == null || file == null || protectionParameter == null) {
                throw new NullPointerException();
            }
            if (!(protectionParameter instanceof PasswordProtection) && !(protectionParameter instanceof CallbackHandlerProtection)) {
                throw new IllegalArgumentException("Protection must be PasswordProtection or CallbackHandlerProtection");
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException("File does not exist or it does not refer to a normal file: " + file);
            }
            return new FileBuilder(string, provider, file, protectionParameter, AccessController.getContext());
        }

        public static Builder newInstance(final String string, final Provider provider, final ProtectionParameter protectionParameter) {
            if (string == null || protectionParameter == null) {
                throw new NullPointerException();
            }
            AccessControlContext accessControlContext = AccessController.getContext();
            return new Builder(){
                private volatile boolean getCalled;
                private final PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        KeyStore keyStore = provider == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, provider);
                        keyStore.load(new SimpleLoadStoreParameter(protectionParameter));
                        getCalled = true;
                        return keyStore;
                    }
                };

                public synchronized KeyStore getKeyStore() throws KeyStoreException {
                    try {
                        return (KeyStore)AccessController.doPrivileged(this.action);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Throwable throwable = privilegedActionException.getCause();
                        throw new KeyStoreException("KeyStore instantiation failed", throwable);
                    }
                }

                public ProtectionParameter getProtectionParameter(String string2) {
                    if (string2 == null) {
                        throw new NullPointerException();
                    }
                    if (!this.getCalled) {
                        throw new IllegalStateException("getKeyStore() must be called first");
                    }
                    return protectionParameter;
                }
            };
        }

        private static final class FileBuilder
        extends Builder {
            private final String type;
            private final Provider provider;
            private final File file;
            private ProtectionParameter protection;
            private final AccessControlContext context;
            private KeyStore keyStore;
            private Throwable oldException;

            FileBuilder(String string, Provider provider, File file, ProtectionParameter protectionParameter, AccessControlContext accessControlContext) {
                this.type = string;
                this.provider = provider;
                this.file = file;
                this.protection = protectionParameter;
                this.context = accessControlContext;
            }

            public synchronized KeyStore getKeyStore() throws KeyStoreException {
                if (this.keyStore != null) {
                    return this.keyStore;
                }
                if (this.oldException != null) {
                    throw new KeyStoreException("Previous KeyStore instantiation failed", this.oldException);
                }
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        KeyStore keyStore = FileBuilder.this.provider == null ? KeyStore.getInstance(FileBuilder.this.type) : KeyStore.getInstance(FileBuilder.this.type, FileBuilder.this.provider);
                        InputStream inputStream = null;
                        char[] cArray = null;
                        try {
                            Object object;
                            inputStream = new FileInputStream(FileBuilder.this.file);
                            if (FileBuilder.this.protection instanceof PasswordProtection) {
                                cArray = ((PasswordProtection)FileBuilder.this.protection).getPassword();
                            } else {
                                object = ((CallbackHandlerProtection)FileBuilder.this.protection).getCallbackHandler();
                                PasswordCallback passwordCallback = new PasswordCallback("Password for keystore " + FileBuilder.this.file.getName(), false);
                                object.handle(new Callback[]{passwordCallback});
                                cArray = passwordCallback.getPassword();
                                if (cArray == null) {
                                    throw new KeyStoreException("No password provided");
                                }
                                passwordCallback.clearPassword();
                                FileBuilder.this.protection = new PasswordProtection(cArray);
                            }
                            keyStore.load(inputStream, cArray);
                            object = keyStore;
                            return object;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                };
                try {
                    this.keyStore = (KeyStore)AccessController.doPrivileged(privilegedExceptionAction, this.context);
                    return this.keyStore;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    this.oldException = privilegedActionException.getCause();
                    throw new KeyStoreException("KeyStore instantiation failed", this.oldException);
                }
            }

            public synchronized ProtectionParameter getProtectionParameter(String string) {
                if (string == null) {
                    throw new NullPointerException();
                }
                if (this.keyStore == null) {
                    throw new IllegalStateException("getKeyStore() must be called first");
                }
                return this.protection;
            }
        }
    }

    public static class CallbackHandlerProtection
    implements ProtectionParameter {
        private final CallbackHandler handler;

        public CallbackHandlerProtection(CallbackHandler callbackHandler) {
            if (callbackHandler == null) {
                throw new NullPointerException("handler must not be null");
            }
            this.handler = callbackHandler;
        }

        public CallbackHandler getCallbackHandler() {
            return this.handler;
        }
    }

    public static interface Entry {
    }

    public static interface LoadStoreParameter {
        public ProtectionParameter getProtectionParameter();
    }

    public static class PasswordProtection
    implements ProtectionParameter,
    Destroyable {
        private final char[] password;
        private volatile boolean destroyed = false;

        public PasswordProtection(char[] cArray) {
            this.password = cArray == null ? null : (char[])cArray.clone();
        }

        public synchronized char[] getPassword() {
            if (this.destroyed) {
                throw new IllegalStateException("password has been cleared");
            }
            return this.password;
        }

        public synchronized void destroy() throws DestroyFailedException {
            this.destroyed = true;
            if (this.password != null) {
                Arrays.fill(this.password, ' ');
            }
        }

        public synchronized boolean isDestroyed() {
            return this.destroyed;
        }
    }

    public static final class PrivateKeyEntry
    implements Entry {
        private final PrivateKey privKey;
        private final Certificate[] chain;

        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] certificateArray) {
            if (privateKey == null || certificateArray == null) {
                throw new NullPointerException("invalid null input");
            }
            if (certificateArray.length == 0) {
                throw new IllegalArgumentException("invalid zero-length input chain");
            }
            Certificate[] certificateArray2 = (Certificate[])certificateArray.clone();
            String string = certificateArray2[0].getType();
            for (int i = 1; i < certificateArray2.length; ++i) {
                if (string.equals(certificateArray2[i].getType())) continue;
                throw new IllegalArgumentException("chain does not contain certificates of the same type");
            }
            if (!privateKey.getAlgorithm().equals(certificateArray2[0].getPublicKey().getAlgorithm())) {
                throw new IllegalArgumentException("private key algorithm does not match algorithm of public key in end entity certificate (at index 0)");
            }
            this.privKey = privateKey;
            if (certificateArray2[0] instanceof X509Certificate && !(certificateArray2 instanceof X509Certificate[])) {
                this.chain = new X509Certificate[certificateArray2.length];
                System.arraycopy(certificateArray2, 0, this.chain, 0, certificateArray2.length);
            } else {
                this.chain = certificateArray2;
            }
        }

        public PrivateKey getPrivateKey() {
            return this.privKey;
        }

        public Certificate[] getCertificateChain() {
            return (Certificate[])this.chain.clone();
        }

        public Certificate getCertificate() {
            return this.chain[0];
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Private key entry and certificate chain with " + this.chain.length + " elements:\r\n");
            for (Certificate certificate : this.chain) {
                stringBuilder.append(certificate);
                stringBuilder.append("\r\n");
            }
            return stringBuilder.toString();
        }
    }

    public static interface ProtectionParameter {
    }

    public static final class SecretKeyEntry
    implements Entry {
        private final SecretKey sKey;

        public SecretKeyEntry(SecretKey secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("invalid null input");
            }
            this.sKey = secretKey;
        }

        public SecretKey getSecretKey() {
            return this.sKey;
        }

        public String toString() {
            return "Secret key entry with algorithm " + this.sKey.getAlgorithm();
        }
    }

    static class SimpleLoadStoreParameter
    implements LoadStoreParameter {
        private final ProtectionParameter protection;

        SimpleLoadStoreParameter(ProtectionParameter protectionParameter) {
            this.protection = protectionParameter;
        }

        public ProtectionParameter getProtectionParameter() {
            return this.protection;
        }
    }

    public static final class TrustedCertificateEntry
    implements Entry {
        private final Certificate cert;

        public TrustedCertificateEntry(Certificate certificate) {
            if (certificate == null) {
                throw new NullPointerException("invalid null input");
            }
            this.cert = certificate;
        }

        public Certificate getTrustedCertificate() {
            return this.cert;
        }

        public String toString() {
            return "Trusted certificate entry:\r\n" + this.cert.toString();
        }
    }
}

