/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XEmbed {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.X11.xembed");
    static final Unsafe unsafe = XlibWrapper.unsafe;
    static final int XEMBED_VERSION = 0;
    static final int XEMBED_MAPPED = 1;
    static final int XEMBED_EMBEDDED_NOTIFY = 0;
    static final int XEMBED_WINDOW_ACTIVATE = 1;
    static final int XEMBED_WINDOW_DEACTIVATE = 2;
    static final int XEMBED_REQUEST_FOCUS = 3;
    static final int XEMBED_FOCUS_IN = 4;
    static final int XEMBED_FOCUS_OUT = 5;
    static final int XEMBED_FOCUS_NEXT = 6;
    static final int XEMBED_FOCUS_PREV = 7;
    static final int XEMBED_MODALITY_ON = 10;
    static final int XEMBED_MODALITY_OFF = 11;
    static final int XEMBED_REGISTER_ACCELERATOR = 12;
    static final int XEMBED_UNREGISTER_ACCELERATOR = 13;
    static final int XEMBED_ACTIVATE_ACCELERATOR = 14;
    static final int XEMBED_FOCUS_CURRENT = 0;
    static final int XEMBED_FOCUS_FIRST = 1;
    static final int XEMBED_FOCUS_LAST = 2;
    static XAtom XEmbedInfo;
    static XAtom XEmbed;

    XEmbed() {
        if (XEmbed == null) {
            XEmbed = XAtom.get("_XEMBED");
            if (xembedLog.isLoggable(Level.FINER)) {
                xembedLog.finer("Created atom " + XEmbed.toString());
            }
        }
        if (XEmbedInfo == null) {
            XEmbedInfo = XAtom.get("_XEMBED_INFO");
            if (xembedLog.isLoggable(Level.FINER)) {
                xembedLog.finer("Created atom " + XEmbedInfo.toString());
            }
        }
    }

    void sendMessage(long l, int n) {
        this.sendMessage(l, n, 0L, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(long l, int n, long l2, long l3, long l4) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.set_type(33);
        xClientMessageEvent.set_window(l);
        xClientMessageEvent.set_message_type(XEmbed.getAtom());
        xClientMessageEvent.set_format(32);
        xClientMessageEvent.set_data(0, XToolkit.getCurrentServerTime());
        xClientMessageEvent.set_data(1, n);
        xClientMessageEvent.set_data(2, l2);
        xClientMessageEvent.set_data(3, l3);
        xClientMessageEvent.set_data(4, l4);
        try {
            XToolkit.awtLock();
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Sending " + xClientMessageEvent);
            }
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), l, false, 0L, xClientMessageEvent.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        xClientMessageEvent.dispose();
    }

    static String msgidToString(int n) {
        switch (n) {
            case 0: {
                return "XEMBED_EMBEDDED_NOTIFY";
            }
            case 1: {
                return "XEMBED_WINDOW_ACTIVATE";
            }
            case 2: {
                return "XEMBED_WINDOW_DEACTIVATE";
            }
            case 4: {
                return "XEMBED_FOCUS_IN";
            }
            case 5: {
                return "XEMBED_FOCUS_OUT";
            }
            case 3: {
                return "XEMBED_REQUEST_FOCUS";
            }
            case 6: {
                return "XEMBED_FOCUS_NEXT";
            }
            case 7: {
                return "XEMBED_FOCUS_PREV";
            }
            case 10: {
                return "XEMBED_MODALITY_ON";
            }
            case 11: {
                return "XEMBED_MODALITY_OFF";
            }
            case 12: {
                return "XEMBED_REGISTER_ACCELERATOR";
            }
            case 13: {
                return "XEMBED_UNREGISTER_ACCELERATOR";
            }
            case 14: {
                return "XEMBED_ACTIVATE_ACCELERATOR";
            }
        }
        return "unknown XEMBED id " + n;
    }

    static String focusIdToString(int n) {
        switch (n) {
            case 0: {
                return "XEMBED_FOCUS_CURRENT";
            }
            case 1: {
                return "XEMBED_FOCUS_FIRST";
            }
            case 2: {
                return "XEMBED_FOCUS_LAST";
            }
        }
        return "unknown focus id " + n;
    }
}

