/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontManager;
import sun.font.Type1GlyphMapper;
import sun.java2d.Disposer;

public class Type1Font
extends FileFont {
    WeakReference bufferRef = new WeakReference<Object>(null);
    private String psName = null;
    private static HashMap styleAbbreviationsMapping;
    private static HashSet styleNameTokes;
    private static final int PSEOFTOKEN = 0;
    private static final int PSNAMETOKEN = 1;
    private static final int PSSTRINGTOKEN = 2;

    public Type1Font(String string, Object object) throws FontFormatException {
        super(string, object);
        this.fontRank = 4;
        this.checkedNatives = true;
        this.verify();
    }

    private synchronized ByteBuffer getBuffer() throws FontFormatException {
        MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)this.bufferRef.get();
        if (mappedByteBuffer == null) {
            try {
                RandomAccessFile randomAccessFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return new RandomAccessFile(Type1Font.this.platName, "r");
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }
                });
                FileChannel fileChannel = randomAccessFile.getChannel();
                this.fileSize = (int)fileChannel.size();
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileSize);
                mappedByteBuffer.position(0);
                this.bufferRef = new WeakReference<MappedByteBuffer>(mappedByteBuffer);
                fileChannel.close();
            }
            catch (NullPointerException nullPointerException) {
                throw new FontFormatException(nullPointerException.toString());
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                return this.getBuffer();
            }
            catch (IOException iOException) {
                throw new FontFormatException(iOException.toString());
            }
        }
        return mappedByteBuffer;
    }

    protected void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFile(ByteBuffer byteBuffer) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return new RandomAccessFile(Type1Font.this.platName, "r");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
            });
            FileChannel fileChannel = randomAccessFile.getChannel();
            fileChannel.read(byteBuffer);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClosedChannelException closedChannelException) {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Thread.interrupted();
            this.readFile(byteBuffer);
        }
        catch (IOException iOException) {
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized ByteBuffer readBlock(int n, int n2) {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = this.getBuffer();
            if (n > this.fileSize) {
                n = this.fileSize;
            }
            byteBuffer.position(n);
            return byteBuffer.slice();
        }
        catch (FontFormatException fontFormatException) {
            return null;
        }
    }

    private void verify() throws FontFormatException {
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer.capacity() < 6) {
            throw new FontFormatException("short file");
        }
        int n = byteBuffer.get(0) & 0xFF;
        if ((byteBuffer.get(0) & 0xFF) == 128) {
            this.verifyPFB(byteBuffer);
            byteBuffer.position(6);
        } else {
            this.verifyPFA(byteBuffer);
            byteBuffer.position(0);
        }
        this.initNames(byteBuffer);
        if (this.familyName == null || this.fullName == null) {
            throw new FontFormatException("Font name not found");
        }
        this.setStyle();
    }

    public int getFileSize() {
        if (this.fileSize == 0) {
            try {
                this.getBuffer();
            }
            catch (FontFormatException fontFormatException) {
                // empty catch block
            }
        }
        return this.fileSize;
    }

    private void verifyPFA(ByteBuffer byteBuffer) throws FontFormatException {
        if (byteBuffer.getShort() != 9505) {
            throw new FontFormatException("bad pfa font");
        }
    }

    private void verifyPFB(ByteBuffer byteBuffer) throws FontFormatException {
        int n = 0;
        try {
            int n2;
            while ((n2 = byteBuffer.getShort(n) & 0xFFFF) == 32769 || n2 == 32770) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int n3 = byteBuffer.getInt(n + 2);
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                if (n3 <= 0) {
                    throw new FontFormatException("bad segment length");
                }
                n += n3 + 6;
            }
            if (n2 == 32771 && n + 2 == this.fileSize) {
                return;
            }
            throw new FontFormatException("bad pfb file");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FontFormatException(bufferUnderflowException.toString());
        }
        catch (Exception exception) {
            throw new FontFormatException(exception.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initNames(ByteBuffer var1_1) throws FontFormatException {
        var2_2 = false;
lbl2:
        // 2 sources

        try {
            while (!(this.fullName != null && this.familyName != null && this.psName != null || var2_2)) {
                block15: {
                    var3_3 = this.nextTokenType(var1_1);
                    if (var3_3 != 1) break block15;
                    var4_6 = var1_1.position();
                    if (var1_1.get(var4_6) == 70) {
                        var5_7 = this.getName(var1_1);
                        if ("FullName".equals(var5_7)) {
                            if (this.nextTokenType(var1_1) != 2) continue;
                            this.fullName = this.getString(var1_1);
                            continue;
                        }
                        if ("FamilyName".equals(var5_7)) {
                            if (this.nextTokenType(var1_1) != 2) continue;
                            this.familyName = this.getString(var1_1);
                            continue;
                        }
                        if (!"FontName".equals(var5_7) || this.nextTokenType(var1_1) != 1) continue;
                        this.psName = this.getName(var1_1);
                        continue;
                    }
                    while (var1_1.get() > 32) {
                    }
                    ** GOTO lbl2
                }
                if (var3_3 != 0) continue;
                var2_2 = true;
            }
        }
        catch (Exception var3_4) {
            throw new FontFormatException(var3_4.toString());
        }
        if (this.psName == null) {
            var1_1.position(0);
            if (var1_1.getShort() != 9505) {
                var1_1.position(8);
            }
            if (!(var3_5 = this.getName(var1_1)).startsWith("FontType1-") && !var3_5.startsWith("PS-AdobeFont-")) {
                throw new FontFormatException("Unsupported font format [" + var3_5 + "]");
            }
            var1_1.get();
            this.psName = this.getName(var1_1);
        }
        if (var2_2) {
            if (this.fullName != null) {
                this.familyName = this.fullName2FamilyName(this.fullName);
            } else if (this.familyName != null) {
                this.fullName = this.familyName;
            } else {
                this.fullName = this.psName2FullName(this.psName);
                this.familyName = this.psName2FamilyName(this.psName);
            }
        }
    }

    private String fullName2FamilyName(String string) {
        int n = string.length();
        while (n > 0) {
            int n2;
            for (n2 = n - 1; n2 > 0 && string.charAt(n2) != ' '; --n2) {
            }
            if (!this.isStyleToken(string.substring(n2 + 1, n))) {
                return string.substring(0, n);
            }
            n = n2;
        }
        return string;
    }

    private String expandAbbreviation(String string) {
        if (styleAbbreviationsMapping.containsKey(string)) {
            return (String)styleAbbreviationsMapping.get(string);
        }
        return string;
    }

    private boolean isStyleToken(String string) {
        return styleNameTokes.contains(string);
    }

    private String psName2FullName(String string) {
        String string2;
        int n = string.indexOf("-");
        if (n >= 0) {
            string2 = this.expandName(string.substring(0, n), false);
            string2 = string2 + " " + this.expandName(string.substring(n + 1), true);
        } else {
            string2 = this.expandName(string, false);
        }
        return string2;
    }

    private String psName2FamilyName(String string) {
        String string2 = string;
        if (string2.indexOf("-") > 0) {
            string2 = string2.substring(0, string2.indexOf("-"));
        }
        return this.expandName(string2, false);
    }

    private int nextCapitalLetter(String string, int n) {
        while (n >= 0 && n < string.length()) {
            if (string.charAt(n) >= 'A' && string.charAt(n) <= 'Z') {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String expandName(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            int n2 = this.nextCapitalLetter(string, n + 1);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (n != 0) {
                stringBuffer.append(" ");
            }
            if (bl) {
                stringBuffer.append(this.expandAbbreviation(string.substring(n, n2)));
            } else {
                stringBuffer.append(string.substring(n, n2));
            }
            n = n2;
        }
        return stringBuffer.toString();
    }

    private byte skip(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        while (by == 37) {
            while ((by = byteBuffer.get()) != 13 && by != 10) {
            }
        }
        while (by <= 32) {
            by = byteBuffer.get();
        }
        return by;
    }

    private int nextTokenType(ByteBuffer byteBuffer) {
        try {
            byte by = this.skip(byteBuffer);
            while (true) {
                if (by == 47) {
                    return 1;
                }
                if (by == 40) {
                    return 2;
                }
                if (by == 13 || by == 10) {
                    by = this.skip(byteBuffer);
                    continue;
                }
                by = byteBuffer.get();
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return 0;
        }
    }

    private String getName(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        while (byteBuffer.get() > 32) {
        }
        int n2 = byteBuffer.position();
        byte[] byArray = new byte[n2 - n - 1];
        byteBuffer.position(n);
        byteBuffer.get(byArray);
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    private String getString(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        while (byteBuffer.get() != 41) {
        }
        int n2 = byteBuffer.position();
        byte[] byArray = new byte[n2 - n - 1];
        byteBuffer.position(n);
        byteBuffer.get(byArray);
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public String getPostscriptName() {
        return this.psName;
    }

    private native long createScaler(int var1);

    protected synchronized long getScaler() {
        if (this.pScaler == 0L) {
            this.pScaler = this.createScaler(this.fileSize);
            if (this.pScaler != 0L) {
                Disposer.addObjectRecord(this, new FileFont.FileFontDisposer(this.pScaler));
            } else {
                this.pScaler = Type1Font.getNullScaler();
                FontManager.deRegisterBadFont(this);
            }
        }
        return this.pScaler;
    }

    CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new Type1GlyphMapper(this);
        }
        return this.mapper;
    }

    native int getNumGlyphs(long var1);

    native int getMissingGlyphCode(long var1);

    synchronized native int getGlyphCode(long var1, char var3);

    public String toString() {
        return "** Type1 Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + " fileName=" + this.platName;
    }

    static {
        int n;
        styleAbbreviationsMapping = new HashMap();
        styleNameTokes = new HashSet();
        String[] stringArray = new String[]{"Black", "Bold", "Book", "Demi", "Heavy", "Light", "Meduium", "Nord", "Poster", "Regular", "Super", "Thin", "Compressed", "Condensed", "Compact", "Extended", "Narrow", "Inclined", "Italic", "Kursiv", "Oblique", "Upright", "Sloped", "Semi", "Ultra", "Extra", "Alternate", "Alternate", "Deutsche Fraktur", "Expert", "Inline", "Ornaments", "Outline", "Roman", "Rounded", "Script", "Shaded", "Swash", "Titling", "Typewriter"};
        String[] stringArray2 = new String[]{"Blk", "Bd", "Bk", "Dm", "Hv", "Lt", "Md", "Nd", "Po", "Rg", "Su", "Th", "Cm", "Cn", "Ct", "Ex", "Nr", "Ic", "It", "Ks", "Obl", "Up", "Sl", "Sm", "Ult", "X", "A", "Alt", "Dfr", "Exp", "In", "Or", "Ou", "Rm", "Rd", "Scr", "Sh", "Sw", "Ti", "Typ"};
        String[] stringArray3 = new String[]{"Black", "Bold", "Book", "Demi", "Heavy", "Light", "Medium", "Nord", "Poster", "Regular", "Super", "Thin", "Compressed", "Condensed", "Compact", "Extended", "Narrow", "Inclined", "Italic", "Kursiv", "Oblique", "Upright", "Sloped", "Slanted", "Semi", "Ultra", "Extra"};
        for (n = 0; n < stringArray.length; ++n) {
            styleAbbreviationsMapping.put(stringArray2[n], stringArray[n]);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            styleNameTokes.add(stringArray3[n]);
        }
    }
}

