/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import sun.awt.X11ComponentPeer;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.java2d.opengl.GLXSurfaceData;

public class GLXVolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public GLXVolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        int n = sunVolatileImage.getTransparency();
        GLXGraphicsConfig gLXGraphicsConfig = (GLXGraphicsConfig)sunVolatileImage.getGraphicsConfig();
        this.accelerationEnabled = n == 1 || n == 3 && (gLXGraphicsConfig.isCapPresent(16) || gLXGraphicsConfig.isCapPresent(2));
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    protected SurfaceData initAcceleratedSurface() {
        GLXSurfaceData.GLXOffScreenSurfaceData gLXOffScreenSurfaceData;
        Component component = this.vImg.getComponent();
        X11ComponentPeer x11ComponentPeer = component != null ? (X11ComponentPeer)((Object)component.getPeer()) : null;
        try {
            boolean bl = false;
            if (this.context instanceof Boolean) {
                bl = (Boolean)this.context;
            }
            if (bl) {
                gLXOffScreenSurfaceData = GLXSurfaceData.createData(x11ComponentPeer, this.vImg);
            } else {
                GLXGraphicsConfig gLXGraphicsConfig = (GLXGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel colorModel = gLXGraphicsConfig.getColorModel(this.vImg.getTransparency());
                int n = gLXGraphicsConfig.isCapPresent(16) ? 5 : 2;
                gLXOffScreenSurfaceData = GLXSurfaceData.createData(gLXGraphicsConfig, this.vImg.getWidth(), this.vImg.getHeight(), colorModel, this.vImg, n);
            }
        }
        catch (NullPointerException nullPointerException) {
            gLXOffScreenSurfaceData = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            gLXOffScreenSurfaceData = null;
        }
        return gLXOffScreenSurfaceData;
    }

    protected boolean isConfigValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration == this.vImg.getGraphicsConfig();
    }
}

