/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)inet_network.c	5.5 (Berkeley) 6/27/88";
#endif /* LIBC_SCCS and not lint */

#include "inetprivate.h"

/*
 * Internet network address interpretation routine.
 * The library routines call this routine to interpret
 * network numbers.
 */
u_long
inet_network(const char *cp)
{
	register u_long val, base, n;
	register char c;
	u_long parts[4], *pp = parts;

again:
	/*
	 * Collect number up to ``.''.
	 * Values are specified as for C:
	 * 0x=hex, 0=octal, other=decimal.
	 */
	val = 0; base = 10;
	if (*cp == '0') {
		if (*++cp == 'x' || *cp == 'X')
			base = 16, cp++;
		else
			base = 8;
	}
	while (c = *cp) {
		if (isdigit(c)) {
			val = (val * base) + (c - '0');
			cp++;
			continue;
		}
		if (base == 16 && isxdigit(c)) {
			val = (val << 4) + (c + 10 - (islower(c) ? 'a' : 'A'));
			cp++;
			continue;
		}
		break;
	}
	if (*cp == '.') {
		/*
		 * Internet format:
		 *	a.b.c.d
		 *	a.b.c	(with c treated as 16-bits)
		 *	a.b	(with b treated as 24 bits)
		 *
		 * For network format, it is
		 *	a.b.c.d	(with each treated as 8-bits)
		 *	a.b.c	(with each treated as 8-bits)
		 *	a.b	(with each treated as 8 bits)
		 *	a	(with a treated as 8 bits)
		 *
		 */
		if (pp >= parts + 3)
			return (INADDR_NONE);
		*pp++ = val, cp++;
		goto again;
	}
	/*
	 * Check for trailing characters.
	 */
	if ((*cp == '\0' && *(cp - 1) == '.') || (*cp && !isspace(*cp)))
		return (INADDR_NONE);
	*pp++ = val;
	/*
	 * Concoct the address according to
	 * the number of parts specified.
	 */
	n = pp - parts;
	switch (n) {

#if 1
	case 1:				/* a -- 32 bits */
		val = parts[0] & 0xff;
		break;

	case 2:				/* a.b -- 24.8 bits */
		val = ((parts[0] & 0xff) << 8) | (parts[1] & 0xff);
		break;

	case 3:				/* a.b.c -- 16.8.8 bits */
		val = ((parts[0] & 0xff) << 16) | ((parts[1] & 0xff) << 8) |
			(parts[2] & 0xff);
		break;

	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		val = ((parts[0] & 0xff) << 24) | ((parts[1] & 0xff) << 16) |
		      ((parts[2] & 0xff) << 8) | (parts[3] & 0xff);
		break;
#else
	case 1:				/* a -- 32 bits */
		val = parts[0];
		break;

	case 2:				/* a.b -- 8.24 bits */
		val = (parts[0] << 24) | (parts[1] & 0xffffff);
		break;

	case 3:				/* a.b.c -- 8.8.16 bits */
		val = (parts[0] << 24) | ((parts[1] & 0xff) << 16) |
			(parts[2] & 0xffff);
		break;

	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		val = (parts[0] << 24) | ((parts[1] & 0xff) << 16) |
		      ((parts[2] & 0xff) << 8) | (parts[3] & 0xff);
		break;
#endif

	default:
		return (INADDR_NONE);
	}
#if 0
	/* I didn't get it. Why doesn't it mask out hostid?
	 * I got it. It is for subnet. H.J.
	 */
	if (IN_CLASSA (val))
		val &= IN_CLASSA_NET;
	else if (IN_CLASSB (val))
		val &= IN_CLASSB_NET;
	else
		val &= IN_CLASSC_NET;
#endif
#if 0
	/* We return the network number. */
	if (IN_CLASSA(val))
		return (((val)&IN_CLASSA_NET) >> IN_CLASSA_NSHIFT);
	else if (IN_CLASSB(val))
		return (((val)&IN_CLASSB_NET) >> IN_CLASSB_NSHIFT);
	else
		return (((val)&IN_CLASSC_NET) >> IN_CLASSC_NSHIFT);
#endif
	return (val);
}
