/* genscript - Font-creation tool for NTeX V1.0
*  Copyright 1994, Frank Langbein
*  All rights reserved.
* 
*  Redistributions of this script must retain the above copyright notice, 
*  this condition and the following disclaimer.
*
*  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
*  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO
*  EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
*  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
*  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
*  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>

void readword(word)
char *word;
{
  char c;
  int pos=0;

  do
    {
      c=getchar();
      if (c == EOF)
	{
	  fprintf(stderr,"genscript: unexpected EOF!");
	  exit(-1);
	}
    }
  while(c == ' ' || c == 10 || c == 13 || c == 9);
  while(c != ' ' && c != 10 && c != 13 && c != 9)
    {
      word[pos] = c;
      pos++;
      c = getchar();
      if (c == EOF)
	{
	  fprintf(stderr,"genscript: unexpected EOF!");
	  exit(-1);
	}  
    }
  word[pos]=0;
  return;
}

void writeword(word)
char *word;
{
  while(*word)
    {
      putchar(*word);
      word++;
    }
  return;
}

void main()
{
  char dir[255],mode[255],word[255];
  int process=1,pos,c;

  do
    {
      readword(word);
    }
  while(strcmp(word,"BEGIN") != 0);

  while(process)
    {
      readword(word);
      if (*word == '!')
	{
	  strcpy(mode,word+1);
	}
      else if(*word == '/')
	{
	  strcpy(dir,word);
	}
      else if(strcmp(word,"END") == 0)
	{
	  process=0;
	}
      else
	{
	  writeword("/usr/lib/texmf/fonts/create/create_pk_tfm ");
	  writeword(word);
	  putchar(' ');
	  putchar('.');
	  writeword(dir);
	  putchar(' ');
	  writeword(mode);
	  c = ' ';
	  while(c != 10 && c != 13 && c != EOF)
	    {
	      putchar(c);
	      c = getchar();
	    }
	  putchar(10);
	}
    }
}
