.TH Adjuster 3I "15 January 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
Adjuster \- button-like interactors for incremental scrolling and zooming
.SH SYNOPSIS
.B #include <InterViews/adjuster.h>
.SH DESCRIPTION
\fBAdjuster\fP objects manipulate a
perspective using a pushbutton-like interface.  Adjusters also provide an
auto-repeat capability.
Depressing and holding down any mouse button on an
adjuster for a specified time causes it to repeatedly perform its operation.
The auto-repeat terminates when the button is released.

Predefined subclasses of Adjuster include \fBZoomer\fP and \fBMover\fP.
Zoomers adjust the perspective's \fIcurwidth\fP and \fIcurheight\fP 
members to suggest magnification.  The user clicks
on a zoomer to magnify or reduce the contents of the interactor through
its perspective.  The \fBEnlarger\fP zoomer subclass
halves the perspective values while the \fBReducer\fP class doubles them.  
Movers provide an incremental movement of the perspective in
one of four directions; left, right, down, or up.  The user clicks on a
mover to move the perspective.  
.SH PUBLIC OPERATIONS
.TP
.B "Adjuster(Interactor*, int = NO_AUTOREPEAT)"
Adjuster constructors take a pointer to the interactor whose perspective 
will be adjusted and
a delay (in tenths of a second) after which auto-repeat will begin once the
adjuster is ``pressed''.
.TP
.B "virtual void Highlight()"
.ns
.TP
.B "virtual void UnHighlight()"
These functions define how the adjuster draws itself when it is pressed.
The adjuster is highlighted when it is pressed with any mouse button
and unhighlighted when the button is released.  The default is to invert the
adjuster when highlighted.
.SH PROTECTED OPERATIONS
.TP
.B "virtual void AdjustView(Event&)"
This function defines how the adjuster adjusts the interactor's 
perspective.  It is 
called after the adjuster is pressed and released, or repeatedly during
auto-repeat.  Derived classes should redefine this function to implement the
desired behavior.
.SH DERIVED CLASSES
.TP
.B "Enlarger(Interactor*)"
.ns
.TP
.B "Reducer(Interactor*)"
Enlargers and reducers adjust an interactor's perspective to enlarge and
reduce the visible area by factors of one half and two, respectively.  This
suggests to an interactor to enlarge or reduce its contents.  
Auto-repeat is disabled on these adjusters.
.TP
.B "LeftMover(Interactor*, int delay = NO_AUTOREPEAT)"
.ns
.TP
.B "RightMover(Interactor*, int delay = NO_AUTOREPEAT)"
.ns
.TP
.B "DownMover(Interactor*, int delay = NO_AUTOREPEAT)"
.ns
.TP
.B "UpMover(Interactor*, int delay = NO_AUTOREPEAT)"
These subclasses of \fBMover\fP adjust the current origin of the
interactor's perspective by an amount in the corresponding direction.  If
the shift key is down while the mover is pressed, the amount corresponds to
the perspective's \fIlx\fP or \fIly\fP member variables; otherwise, the
\fIsx\fP or \fIsy\fP values are used.
.SH SEE ALSO
Interactor(3I), Perspective(3I)
