/*
 * runlevel	Prints out the previous and the current runlevel.
 *
 * Author:	Miquel van Smoorenburg, <miquels@drinkel.nl.mugnet.org>
 * Date:	24-Oct-1993
 * Version:	1.0
 */

#include <stdio.h>
#include <utmp.h>
#include <time.h>

int main(argc, argv)
int argc;
char **argv;
{
  FILE *fp;
  struct utmp ut;
  char *file = UTMP_FILE;
  char prev;

  if (argc > 1) file = argv[1];
  if ((fp = fopen(file, "r")) != NULL) {
    while (fread(&ut, sizeof(struct utmp), 1, fp) == 1) {
	if (ut.ut_type == RUN_LVL) {
		prev = ut.ut_pid / 256;
		if (prev == 0) prev = 'N';
		printf("%c %c\n", prev, ut.ut_pid % 256);
		fclose(fp);
		exit(0);
	}
    }
  }
  
  printf("unknown\n");
  if (fp) fclose(fp);
  return(1);
}
