/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                              A - T R A N S                               */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.19 $                             */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

#define BAD_GNAT_TREE ((Node_Id) -1)

/* This function isn't in sinfo.h since we don't make the setting functions,
   just the retreival functions.  This is the single exception to the rule
   that Gigi doesn't modify the tree.  */
#define Set_Has_No_Elab_Code sinfo__set_has_no_elab_code
extern void Set_Has_No_Elab_Code	PROTO((Node_Id, Boolean));

/* Offset from first sloc in file.  Set in parallel with LINENO
   and CURRENT_FILE_NAME.  */
extern int sloc_offset;

/* For most front-ends, this is the parser for the language.  For us, we
   process the GNAT tree.  */
extern int yyparse		PROTO((void));

/* This function is the driver of the GNAT to GCC tree transformation process.
   GNAT_NODE is the root of some gnat tree.  It generates code for that
   part of the tree.  */
extern void gnat_to_code	PROTO((Node_Id));

/* GNAT_NODE is the root of some GNAT tree.  Return the root of the
   GCC tree corresponding to that GNAT tree.  Normally, no code is generated;
   we just return an equivalent tree which is used elsewhere to generate
   code.  */
extern tree gnat_to_gnu		PROTO((Node_Id));

/* Determine the input_filename and the lineno from the source location
   (Sloc) of GNAT_NODE node.  Set the global variable input_filename and
   lineno.  If WRITE_NOTE_P is true, emit a line number note. */
extern void set_lineno		PROTO((Node_Id, int));

/* Post an error message.  MSG is the error message, properly annotated.
   NODE is the node at which to post the error and the node to use for the
   "&" substitution.  */
extern void post_error		PROTO((char *, Node_Id));

/* Signal abort, with "Gigi abort" as the error label, and error_gnat_node
   as the relevant node that provides the location info for the error.
   The single parameter CODE is an integer code that is included in the
   additional error message generated */
extern void gigi_abort          PROTO((int));

/* Initialize the table that maps GNAT codes to GCC codes for simple
   binary and unary operations.  */
extern void init_code_table	PROTO((void));

/* process all implicit types entities attached to a node */
extern void process_implicit_types PROTO ((Node_Id));

#if 0
----------------------
-- REVISION HISTORY --
----------------------

----------------------------
revision 1.17
date: Tue Mar  8 05:44:05 1994;  author: kenner
Use Node_Id and Entity_Id instead of gnat_tree.
----------------------------
revision 1.18
date: Tue Mar 15 11:56:12 1994;  author: comar
add profile of process_implicit_types
----------------------------
revision 1.19
date: Sun Aug 14 16:05:40 1994;  author: kenner
(Set_Has_No_Elab_Code): Add macro and definition.
----------------------------
** New changes after this line and before endif. **
#endif
