-----------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              G N A T V S N                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.81 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package Gnatvsn is

--  This package spec holds version information for GNAT and GBIND. It should
--  be updated periodically to reflect changes and in partciular should be
--  updated when bugs in the bug log are fixed.

   Gnat_Version_String : constant String := "1.82";
   --  Version output when GNAT itself is run (in verbose mode)

   Gnatbind_Version_String : constant String := "1.21";
   --  Version output when GNATBIND is run (in verbose mode)

   Gnatmake_Version_String : constant String := "1.01";
   --  Version output when GNATMAKE is run

   Sgnat_Version_String : constant String (1 .. 16) := "SGNAT v1.0      ";
   --  Sgnat version. Written in the .xr? files.
   --  Abocve comment knows too much about names of files ???
   --  What the heck is this anyway ???

   Library_Version : constant String (1 .. 16) := "GNAT Lib v1.2   ";
   --  Library version. This value must be updated whenever any change to the
   --  compiler affects the library formats in such a way as to obsolete
   --  previously compiled library modules.

   Standard_Version : String (1 .. 16)  := "                ";
   --  A string identifying the version of Standard. Used for library output
   --  and by the binder to check that all modules use the same version of
   --  Standard (otherwise the bind is not permitted). This is updated
   --  whenever a change to Standard requires complete recompilation. The
   --  actual value of this string is established by the Stand package when
   --  package Standard is constructed.

end Gnatvsn;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.79
--  date: Sun Jul 17 11:49:57 1994;  author: porter
--  Increment version numbers following 1.81 release.
--  ----------------------------
--  revision 1.80
--  date: Tue Jul 19 07:03:06 1994;  author: gasperon
--  Added declaration of the string containing the version of sgnat.
--  ----------------------------
--  revision 1.81
--  date: Thu Jul 21 02:48:16 1994;  author: dewar
--  Add ??? for mysterious new uncommented sgnat version string
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
