------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             S E M _ C H 1 3                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.12 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;

package Sem_Ch13 is
   procedure Analyze_At_Clause                          (N : Node_Id);
   procedure Analyze_Attribute_Definition_Clause        (N : Node_Id);
   procedure Analyze_Enumeration_Representation_Clause  (N : Node_Id);
   procedure Analyze_Free_Statement                     (N : Node_Id);
   procedure Analyze_Record_Representation_Clause       (N : Node_Id);
   procedure Analyze_Code_Statement                     (N : Node_Id);

   function Freeze_Entity (E : Entity_Id; Loc : Source_Ptr) return List_Id;
   --  Freeze an entity, and return Freeze nodes, to be inserted at the
   --  point of call. Loc is a source location which corresponds to the
   --  freeze point. This is used in placing warning messages in the
   --  situation where it appears that a type has been frozen too early,
   --  e.g. when a primitive operation is declared after the freezing
   --  point of its tagged type.

   function Freeze_All (Scope : Entity_Id) return List_Id;
   --  Before a non-instance body, or at the end of a declarative part
   --  freeze all entities therein that are not yet frozen. Calls itself
   --  recursively to catch types in inner packages that were not frozen
   --  at the inner level because they were not yet completely defined.

   procedure Freeze_Before (N : Node_Id; T : Entity_Id);
   --  Freeze T then Insert the generated Freeze nodes before the node N.

   procedure Freeze_Expression (N : Node_Id);
   --  Freezes the required entities when the Expression N causes freezing.

   procedure Validate_Unchecked_Conversion (N : Node_Id; Act_Unit : Entity_Id);
   --  Validate a call to unchecked conversion. N is the node for the actual
   --  instantiation, which is used only for error messages. Act_Unit is the
   --  entity for the instantiation, from which the actual types etc for this
   --  instantiation can be determined.

end Sem_Ch13;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.10
--  date: Thu Jun  9 13:39:13 1994;  author: schenker
--  (Freeze_All): Add an argument (the Scope to be frozen) since it is now
--   being called recursively to freeze types in inner packages that were
--   incomplete at the end of their declarative part.
--  ----------------------------
--  revision 1.11
--  date: Thu Aug 18 16:26:54 1994;  author: comar
--  Add new procedure Analyze_Free_Statement.
--  ----------------------------
--  revision 1.12
--  date: Thu Aug 18 20:10:25 1994;  author: dewar
--  Minor reformatting
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
