------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              S E M _ C H 9                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.6 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;
package Sem_Ch9  is
   procedure Analyze_Task_Type                          (N : Node_Id);
   procedure Analyze_Single_Task                        (N : Node_Id);
   procedure Analyze_Task_Definition                    (N : Node_Id);
   procedure Analyze_Task_Body                          (N : Node_Id);
   procedure Analyze_Protected_Type                     (N : Node_Id);
   procedure Analyze_Single_Protected                   (N : Node_Id);
   procedure Analyze_Protected_Definition               (N : Node_Id);
   procedure Analyze_Protected_Body                     (N : Node_Id);
   procedure Analyze_Entry_Declaration                  (N : Node_Id);
   procedure Analyze_Entry_Body                         (N : Node_Id);
   procedure Analyze_Entry_Body_Formal_Part             (N : Node_Id);
   procedure Analyze_Entry_Index_Specification          (N : Node_Id);
   procedure Analyze_Accept_Statement                   (N : Node_Id);
   procedure Analyze_Requeue                            (N : Node_Id);
   procedure Analyze_Delay_Until                        (N : Node_Id);
   procedure Analyze_Delay_Relative                     (N : Node_Id);
   procedure Analyze_Selective_Accept                   (N : Node_Id);
   procedure Analyze_Accept_Alternative                 (N : Node_Id);
   procedure Analyze_Delay_Alternative                  (N : Node_Id);
   procedure Analyze_Terminate_Alternative              (N : Node_Id);
   procedure Analyze_Conditional_Entry_Call             (N : Node_Id);
   procedure Analyze_Entry_Call_Alternative             (N : Node_Id);
   procedure Analyze_Timed_Entry_Call                   (N : Node_Id);
   procedure Analyze_Asynchronous_Select                (N : Node_Id);
   procedure Analyze_Triggering_Alternative             (N : Node_Id);
   procedure Analyze_Abortable_Part                     (N : Node_Id);
   procedure Analyze_Abort_Statement                    (N : Node_Id);
end Sem_Ch9;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.4
--  date: Mon Nov 29 22:52:45 1993;  author: dewar
--  (Analyze_Entry_Body_Formal_Part) new procedure for new node
--  ----------------------------
--  revision 1.5
--  date: Sun Jan  9 11:08:40 1994;  author: dewar
--  New header with 1994 copyright
--  ----------------------------
--  revision 1.6
--  date: Fri Jul 15 12:36:46 1994;  author: schonber
--  (Analyze_Entry_Call): remove obsolete procedure. Analysis is done in
--   Analyze_Procedure_Call_Statement and elsewhere.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
