------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              U N I X L I B                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.13 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package body Unixlib is

   ----------------------
   -- Unix_File_Length --
   ----------------------

   function Unix_File_Length (FD : Unix_FD) return Int is

      function File_Length (FD : Unix_FD) return Int;
      pragma Import (C, File_Length, "file_length");

   begin
      return File_Length (FD);
   end Unix_File_Length;

   ---------------------------
   -- Unix_File_Time_Stamp  --
   ---------------------------

   function Unix_File_Time_Stamp (FD : Unix_FD) return Time_Stamp_Type is
      Stamp : Time_Stamp_Type;

      procedure File_Time (FD : Unix_FD; Stamp : in out Time_Stamp_Type);
      pragma Import (C, File_Time, "file_time_fd");

   begin
      File_Time (FD, Stamp);
      return Stamp;
   end Unix_File_Time_Stamp;

   ---------------------------
   -- Unix_File_Time_Stamp  --
   ---------------------------

   function Unix_File_Time_Stamp (Name : Address) return Time_Stamp_Type is
      Stamp : Time_Stamp_Type;

      procedure File_Time (Name : Address; Stamp : in out Time_Stamp_Type);
      pragma Import (C, File_Time, "file_time_name");

   begin
      File_Time (Name, Stamp);
      return Stamp;
   end Unix_File_Time_Stamp;

   --------------------------
   -- Unix_Is_Regular_File --
   --------------------------

   function Unix_Is_Regular_File (Name : String) return Boolean is

      function Is_Regular_File (Name : Address) return Integer;
      pragma Import (C, Is_Regular_File, "is_regular_file");

      F_Name : String (1 .. Name'Last + 1);

   begin
      F_Name (Name'range) := Name;
      F_Name (F_Name'Last) := NUL;
      return Is_Regular_File (F_Name'Address) /= 0;
   end Unix_Is_Regular_File;

   -----------------
   -- Unix_Getenv --
   -----------------

   function Unix_Getenv (Name : String) return String is

      procedure Get_Env_Value_Ptr (Name, Length, Ptr : Address);
      pragma Import (C, Get_Env_Value_Ptr, "get_env_value_ptr");

      procedure Strncpy (Astring_Addr, Cstring : Address; N : Integer);
      pragma Import (C, Strncpy, "strncpy");

      Env_Value_Ptr    : Address;
      Env_Value_Length : Integer;
      F_Name           : String (1 .. Name'Last + 1);

   begin
      F_Name (Name'range) := Name;
      F_Name (F_Name'Last) := NUL;

      Get_Env_Value_Ptr
        (F_Name'Address, Env_Value_Length'Address, Env_Value_Ptr'Address);

      declare
         Ret_String : String (1 .. Env_Value_Length);

      begin
         if Env_Value_Length > 0 then
            Strncpy (Ret_String'Address, Env_Value_Ptr, Env_Value_Length);
         end if;

         return Ret_String;
      end;
   end Unix_Getenv;

end Unixlib;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.11
--  date: Wed Jan 26 18:45:41 1994;  author: porter
--  (Unix_Is_Regular_File): new function
--  (Unix_Getenv): new function
--  pragma interfac for strncpy added for internal use
--  ----------------------------
--  revision 1.12
--  date: Tue Apr  5 21:35:09 1994;  author: dewar
--  Use pragma Import instead of pragma Interface and Interface_Name
--  Minor reformatting
--  Fix badly spelled attribute names
--  Spell Unix functions in Unix style, all lower case
--  ----------------------------
--  revision 1.13
--  date: Tue May 31 18:07:52 1994;  author: porter
--  Correct capitalization
--  (Unix_File_Time_Stamp): new version taking filename
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
