#! /bin/sh
#
# NET-BASE	A collection of programs that form the base set of the
#		NET-2 Networking Distribution for the LINUX operating
#		system.
#
# Usage:	Install.sh [--devices] [--firsttime] [--nobackup]
#
# Version:	@(#)Install.sh  1.62	01/20/94
#
# Authors:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
#		Johannes Grosen, <grosen@argv.cs.ndsu.nodak.edu>
#		Copyright 1988-1993 MicroWalt Corporation
#
#		This program is free software; you can redistribute it
#		and/or  modify it under  the terms of  the GNU General
#		Public  License as  published  by  the  Free  Software
#		Foundation;  either  version 2 of the License, or  (at
#		your option) any later version.
#
PATH=/bin:/usr/bin:/sbin:/usr/sbin
export PATH
NROFF="groff -Tascii"	# how to format man pages for catman

BIN_PROGS="hostname netstat"
SBIN_PROGS="arp ifconfig route slattach"

  backup()
  {
	if [ "${nobackup}" = "NO" ]; then
		if [ -s $1 ]; then
			mv $1 $1.old
		fi
	fi
  }

  # Display a prompt, and then ask for Y or N.
  yesno() \
  {
	if [ $# = 0 ]; then
		prompt="Are you sure? (y/n): "
	  else
		prompt="$*: "
	fi
	while true
	do
		echo -n ${prompt}
		read answer
		if [ -n "${answer}" -a \
		     "${answer}" = "y" -o "${answer}" = "Y" -o \
		     "${answer}" = "n" -o "${answer}" = "N" ]; then
			break
		fi
		echo "***** WRONG ANSWER!"
	done
	if [ "${answer}" != "y" -a "${answer}" != "Y" ]; then
		return 1
	  else
		return 0
	fi
  }


  devices=NO
  firsttime=NO
  nobackup=NO
  while [ $# != 0 ]; do
	case $1 in
		--devices)
			devices="YES"
			shift
			;;

		--firsttime)
			firsttime="YES"
			shift
			;;

		--nobackup)
			nobackup="YES"
			shift
			;;

		-*)
			echo "Usage: Install.sh [--devices] [--firsttime] [--nobackup]" >&2
			exit 1
			;;

		*)
			shift
			;;
	esac
  done
  echo
  echo "This procedure will install the NET-2 Base Utilities for you."

  # Check if this is either SLS, Pro or something unknown.
  if [ -d /conf/net ]; then	# Linux/PRO
	ETC="/etc"
	SBIN="/sbin"
	CONF="/conf/net"
	DOLINK=1
	DIRS="/dev /dev/net /conf /conf/net /etc /bin /sbin /usr /usr/bin /usr/man"
    else			# SLS or vanilla
	ETC="/etc"
	SBIN="/sbin"
	CONF="/etc"
	DOLINK=0
	DIRS="/dev /sbin /etc /bin /usr /usr/bin /usr/man"
  fi

  # Are we expected to install preformatted manual pages?
  CATMAN=0
  if [ -d /usr/man/cat1 ]; then
	echo
	if yesno "Do you want me to pre-format the manual pages? (y/n)"; then
		CATMAN=1
	fi
  fi

  # Install the CONFIG files.
  if [ "${firsttime}" = "YES" ]; then
	echo ; echo -n "Installing CONFIG files..."
	cp -a samples/etc/* ${ETC}
	echo "done"
	echo -n "Installing CONFIG (${CONF}) files..."
	cp -a samples/conf/* ${CONF}
	echo "done"
	CONFIG=1

	# Set up those damn symbolic links.
	if [ ${DOLINK} -eq 1 ]; then
		echo -n "Setting up symbolic links..."
		links="`cd ${CONF}; echo *`"
		for i in ${links}
		do
			ln -sf ${CONF}/$i ${ETC}/$i
		done
		echo "done"
	fi
    else
	CONFIG=0
  fi

  # Install the primary user commands.
  echo ; echo "Installing USER commands:"
  for i in ${BIN_PROGS}
  do
	path=/bin/`basename $i`
	echo -n "${path} "
	backup ${path}
	cp $i ${path}
	chmod 511 ${path}
	chown bin.bin ${path}
  done
  (echo -n "/bin/domainname"; cd /bin; ln -sf hostname domainname ; echo)

  # Install the primary system administrator commands.
  echo ; echo "Installing SYSTEM administrator commands:"
  for i in ${SBIN_PROGS}
  do
	path=${SBIN}/`basename $i`
	echo -n "${path} "
	backup ${path}
	cp $i ${path}
	chmod 500 ${path}
	chown bin.bin ${path}
  done
  echo

  # Install the manual pages.
  echo ; echo -n "Installing manual pages..."
  for i in 1 5 8
  do
	# Install manual sources.
	chmod 644 man/*.$i
	chown bin.bin man/*.$i
	cp -af man/*.$i /usr/man/man$i >/dev/null

	# Do we need to pre-format them as well?
	if [ ${CATMAN} -eq 1 ]; then
		for manpage in man/*.$i
		do
			page=`basename ${manpage}`
			rm -f /usr/man/cat${i}/${page}
			${NROFF} -man $manpage > /usr/man/cat${i}/${page}
			chmod 644 /usr/man/cat${i}/${page}
			chown bin.bin /usr/man/cat${i}/${page}
		done
	fi
  done
  (cd /usr/man/man1; ln -sf hostname.1 domainname.1)
  echo

  echo ; echo "Installation completed."
  if [ ${CONFIG} -eq 1 ]; then
	echo
	echo "Do NOT forget to edit the files in ${CONF} just installed."
	echo "or the NET-2 system will not operate correctly!"
  fi
  if [ "${nobackup}" = "NO" ]; then
	echo
	echo "Your old binaries (if they existed) were backed up to <name>.old."
	echo "You may safely delete them once you are satisfied that the new"
	echo "setup is working correctly."
  fi
  echo

  exit 0
