\begindata{text,538268692}
\textdsversion{12}
\template{default}
-- fileconvert.n

--	$$$  This is a prototypical file conversion program

--	$$$  To make a specific file converter, it is only necessary to 

--	$$$   revise the parts marked $$$

--

--	Author: WJHansen


-- $$$  invent a name for your converter and

-- $$$  change all appearances of "fileconvert" below to the new name


-- HERE'S HOW


--    To convert a piece of a document:

--	- Select the piece, type ESC-ESC, and at the 'Ness:' prompt type 

--		fileconvert_convert()


--   To convert an entire file give the command 

--	nessrun /usr/andrew/lib/ness/fileconvert.n <filename>

--   The output will be in a file having the same prefix and the extension 
'.d'

--   An existing file with the name generated for the output will be moved to 

--	the same name with the extension '.old'


-- To have the conversion as a menu option, add to your ~/.atkinit (or other 
.XYZinit):

--	load ness

--	call ness-load FILENAME

-- where FILENAME is the full pathname of this file

-- and where the "load ness" line is only needed once in the entire .XYZinit 
file



marker Letters := "qwertyuiopasdfghjklzxcvbnm_"

		~ "QWERTYUIOPASDFGHJKLZXCVBNM"

marker IdChars := Letters ~ "0123456789"



function convert(s)

	marker cvted := newbase()


-- $$$ parse 's' producing the output version in 'cvted'


	return cvted 

end function



-----------------------------------------------------------------

-- the following provide the three different methods of invoking conversion



-- this function can be called from the Ness: prompt

function fileconvert_convert()

	marker s := currentselection(defaulttext)

	replace (s, convert(s))

end function


-- add an item to the menu for all "textview" objects

extend "view:textview"

on menu "Convert"	-- $$$ change this to change the menu option that will 
appear

	marker s := currentselection(defaulttext)

	replace (s, convert(s))

end menu

end extend


-- this main function executes if this file is invoked with nessrun

function main(args)

	marker filename, outname, ext, m, text, outtext


	filename := token(args, IdChars ~ "./")

	ext := filename

	while ext  /= "" do 

		m := anyof (ext, "./")

		if m = "" then exit while

		else ext := extent(next(m), ext)

		end if

	end while

	-- now ext is the extension if preceded by "."

	if ext = "" then

		printline("You must supply a filename as argument.")

		exit function

	elif previous(ext) = "." and ext /= "d" then

		outname := extent(filename, start(ext)) ~ "d"

	else 

		outname := filename ~ ".d"

	end if

	text := readfile(filename)

	if text = "" then

		printline("empty input file: " ~ filename)

		exit function

	end if


	printline("fileconvert: " ~ filename ~ " -> " ~ outname)

	outtext := convert(text)

	if match(system("if test -f "~outname ~  ";"

			~ "then mv " ~ outname ~ " " ~ outname ~ ".old;"

			~ "echo moved;fi"), "moved") /= "" then

		printline("Moved old " ~ outname ~ " to " ~ outname ~ ".old")

	end if

	writefile(outname, outtext)

end function



-- 
\begindata{bp,537558784}
\enddata{bp,537558784}
\view{bpv,537558784,11,0,0}

-- Copyright 1992 Carnegie Mellon University and IBM.  All rights reserved.

\smaller{\smaller{-- $Disclaimer: 

-- Permission to use, copy, modify, and distribute this software and its 

-- documentation for any purpose is hereby granted without fee, 

-- provided that the above copyright notice appear in all copies and that 

-- both that copyright notice, this permission notice, and the following 

-- disclaimer appear in supporting documentation, and that the names of 

-- IBM, Carnegie Mellon University, and other copyright holders, not be 

-- used in advertising or publicity pertaining to distribution of the software 

-- without specific, written prior permission.

-- 

-- IBM, CARNEGIE MELLON UNIVERSITY, AND THE OTHER COPYRIGHT HOLDERS 

-- DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 

-- ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT 

-- SHALL IBM, CARNEGIE MELLON UNIVERSITY, OR ANY OTHER COPYRIGHT HOLDER 

-- BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 

-- DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 

-- WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 

-- ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 

-- OF THIS SOFTWARE.

--  $

}}\enddata{text,538268692}
