
/*  A Bison parser, made from gpm-root.y with Bison version GNU Bison version 1.22
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	T_STRING	258
#define	T_BACK	259
#define	T_FORE	260
#define	T_BORD	261
#define	T_HEAD	262
#define	T_BRIGHT	263
#define	T_COLOR	264
#define	T_NAME	265
#define	T_BUTTON	266
#define	T_FUNC	267
#define	T_FUN2	268

#line 21 "gpm-root.y"


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <sys/types.h>
#include <sys/syslog.h>
#include <signal.h>        /* sigaction() */
#include <pwd.h>           /* pwd entries */
#include <sys/kd.h>        /* KDGETMODE */
#include <sys/stat.h>      /* fstat() */
#include <termios.h>       /* winsize */
#include <linux/limits.h>  /* OPEN_MAX */
#include <linux/vt.h>      /* VT_ACTIVATE */

#include "gpmCfg.h"  /* need the config one to get GPM_NAME */
#include "gpm.h"

#ifdef DEBUG
#define YYDEBUG 1
#else
#undef YYDEBUG
#endif

#include "wd.h"      /* when debugging macros */

#define USER_CFG   ".gpm-root"
#define SYSTEM_CFG "/etc/gpm-root.conf"

#define DEFAULT_FORE 7
#define DEFAULT_BACK 0
#define DEFAULT_BORD 7
#define DEFAULT_HEAD 7
#define usenewscrdump 1 /* should be a variable */

#if 0
#define PERROR(s) (fprintf(stderr,"%s: ",prgname),perror(s))
#else
#define PERROR(s) syslog(LOG_NOTICE,"%s: %s",s,strerror(errno))
#endif

/* These macros are useful to avoid curses. The program is unportable anyway */
#define GOTOXY(f,x,y)   fprintf(f,"\x1B[%03i;%03iH",y,x)
#define FORECOLOR(f,c)  fprintf(f,"\x1B[%i;3%cm",(c)&8?1:22,colLut[(c)&7]+'0') 
#define BACKCOLOR(f,c)  fprintf(f,"\x1B[4%cm",colLut[(c)&7]+'0') 


#if 0
#ifdef YYDEBUG
#define YYPRINT(file, type, value)   yyprint (file, type, value)

static void yyprint (FILE *file, int type, YYSTYPE value)
{
    if (type == VA)
    fprintf (file, " %s", value.tptr->name);
  else if (type == NUM)
    fprintf (file, " %d", value.val);
}

#endif
#endif

int colLut[]={0,4,2,6,1,5,3,7};

char *prgname;
struct winsize win;

struct node {char *name; int flag;};

struct node  tableMod[]= {
{"shift", 1},
{"anyAlt", 10},
{"leftAlt", 8},
{"rightAlt", 2},
{"control", 4},
{NULL,0}
};

  /* provide defaults */
int opt_mod     =  4;           /* control */
int opt_buf     =  0;           /* ask the kernel about it */
int opt_user    =  1;           /* allow user cfg files */



typedef struct DrawItem {
  short type;
  short pad;
  char *name;
  char *arg;   /* a cmd string */
  void *clientdata;  /* a (Draw *) for menus or whatever   */
  int (*fun)();
  struct DrawItem *next;
} DrawItem;

typedef struct Draw {
  short width;               /* length of longest item */
  short height;              /* the number of items */
  short uid;                 /* owner */
  short buttons;             /* which button */
  short fore,back,bord,head; /* colors */
  char *title;               /* name */
  time_t mtime;              /* timestamp of source file */
  DrawItem *menu;            /* the list of items */
  struct Draw *next;         /* chain */
} Draw;

typedef struct Posted {
  short x,y,X,Y;
  Draw *draw;
  char *dump;
  short colorcell;
  struct Posted *prev;
} Posted;

Draw *drawList=NULL;

/* support functions and vars */
DrawItem *cfg_cat(DrawItem *, DrawItem *);
DrawItem *cfg_makeitem(int mode, char *msg, int(*fun)(), void *detail);


/*===================================================================*
 * This part of the source is devoted to reading the cfg file
 */

char cfgname[256];
FILE *cfgfile=NULL;
int cfglineno=0;
Draw *cfgcurrent, *cfgall;

Draw *cfg_alloc(void);

/* prototypes for predefined functions */

enum F_call {F_CREATE, F_POST, F_INVOKE, F_DONE};
int f_debug(int mode, DrawItem *self, int uid);
int f_bgcmd(int mode, DrawItem *self, int uid);
int f_fgcmd(int mode, DrawItem *self, int uid);
int f_jptty(int mode, DrawItem *self, int uid);
int f_mktty(int mode, DrawItem *self, int uid);
int f_menu(int mode, DrawItem *self, int uid);
int f_lock(int mode, DrawItem *self, int uid);
int f_load(int mode, DrawItem *self, int uid);
int f_free(int mode, DrawItem *self, int uid);
int f_time(int mode, DrawItem *self, int uid);
int f_pipe(int mode, DrawItem *self, int uid);


#line 173 "gpm-root.y"
typedef union {
    int silly;
    char *string;
    Draw *draw;
    DrawItem *item;
    int (*fun)();
    } YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		37
#define	YYFLAG		-32768
#define	YYNTBASE	19

#define YYTRANSLATE(x) ((unsigned)(x) <= 268 ? yytranslate[x] : 29)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,    14,    15,
    16,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    17,     2,    18,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     5,     8,    11,    14,    15,    21,    22,    25,
    28,    31,    35,    39,    43,    44,    46,    49,    50,    53,
    56,    60
};

static const short yyrhs[] = {    -1,
    19,    20,    21,     0,    11,    14,     0,    11,    15,     0,
    11,    16,     0,     0,    17,    22,    23,    26,    18,     0,
     0,    23,    24,     0,    10,     3,     0,     4,     9,     0,
     5,    25,     9,     0,     6,    25,     9,     0,     7,    25,
     9,     0,     0,     8,     0,    28,    27,     0,     0,    27,
    28,     0,     3,    12,     0,     3,    13,     3,     0,     3,
    21,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   192,   193,   196,   197,   198,   201,   202,   205,   205,   207,
   208,   209,   210,   211,   214,   214,   216,   218,   219,   222,
   223,   224
};

static const char * const yytname[] = {   "$","error","$illegal.","T_STRING",
"T_BACK","T_FORE","T_BORD","T_HEAD","T_BRIGHT","T_COLOR","T_NAME","T_BUTTON",
"T_FUNC","T_FUN2","'1'","'2'","'3'","'{'","'}'","file","button","menu","@1",
"configs","cfgpair","bright","itemlist","items","item",""
};
#endif

static const short yyr1[] = {     0,
    19,    19,    20,    20,    20,    22,    21,    23,    23,    24,
    24,    24,    24,    24,    25,    25,    26,    27,    27,    28,
    28,    28
};

static const short yyr2[] = {     0,
     0,     3,     2,     2,     2,     0,     5,     0,     2,     2,
     2,     3,     3,     3,     0,     1,     2,     0,     2,     2,
     3,     2
};

static const short yydefact[] = {     1,
     0,     0,     0,     3,     4,     5,     6,     2,     8,     0,
     0,     0,    15,    15,    15,     0,     9,     0,    18,    20,
     0,    22,    11,    16,     0,     0,     0,    10,     7,    17,
    21,    12,    13,    14,    19,     0,     0
};

static const short yydefgoto[] = {     1,
     3,     8,     9,    10,    17,    25,    18,    30,    19
};

static const short yypact[] = {-32768,
     0,     1,    -5,-32768,-32768,-32768,-32768,-32768,-32768,    -2,
    -3,     4,    10,    10,    10,    16,-32768,     2,-32768,-32768,
    18,-32768,-32768,-32768,    13,    14,    15,-32768,-32768,    22,
-32768,-32768,-32768,-32768,-32768,    26,-32768
};

static const short yypgoto[] = {-32768,
-32768,    17,-32768,-32768,-32768,    -8,-32768,-32768,    -1
};


#define	YYLAST		29


static const short yytable[] = {    36,
    11,    12,    13,    14,    15,    26,    27,    16,    20,    21,
     2,     7,    23,     7,     4,     5,     6,    24,    28,    29,
    31,    32,    33,    34,    11,    37,     0,    22,    35
};

static const short yycheck[] = {     0,
     3,     4,     5,     6,     7,    14,    15,    10,    12,    13,
    11,    17,     9,    17,    14,    15,    16,     8,     3,    18,
     3,     9,     9,     9,     3,     0,    -1,    11,    30
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 184 "/usr/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 192 "gpm-root.y"
{yyval.draw=cfgall=NULL;;
    break;}
case 2:
#line 193 "gpm-root.y"
{yyvsp[0].draw->buttons=yyvsp[-1].silly; yyvsp[0].draw->next=yyvsp[-2].draw; yyval.draw=cfgall=yyvsp[0].draw;
    break;}
case 3:
#line 196 "gpm-root.y"
{yyval.silly=GPM_B_LEFT;;
    break;}
case 4:
#line 197 "gpm-root.y"
{yyval.silly=GPM_B_MIDDLE;;
    break;}
case 5:
#line 198 "gpm-root.y"
{yyval.silly=GPM_B_RIGHT;;
    break;}
case 6:
#line 201 "gpm-root.y"
{yyval.draw=cfgcurrent=cfg_alloc();;
    break;}
case 7:
#line 202 "gpm-root.y"
{yyval.draw=yyvsp[-3].draw; yyval.draw->menu=yyvsp[-1].item;;
    break;}
case 10:
#line 207 "gpm-root.y"
{cfgcurrent->title=yyvsp[0].string;;
    break;}
case 11:
#line 208 "gpm-root.y"
{cfgcurrent->back=yyvsp[0].silly;;
    break;}
case 12:
#line 209 "gpm-root.y"
{cfgcurrent->fore=yyvsp[0].silly|yyvsp[-1].silly;;
    break;}
case 13:
#line 210 "gpm-root.y"
{cfgcurrent->bord=yyvsp[0].silly|yyvsp[-1].silly;;
    break;}
case 14:
#line 211 "gpm-root.y"
{cfgcurrent->head=yyvsp[0].silly|yyvsp[-1].silly;;
    break;}
case 15:
#line 214 "gpm-root.y"
{yyval.silly=0;
    break;}
case 16:
#line 214 "gpm-root.y"
{yyval.silly=8;
    break;}
case 17:
#line 216 "gpm-root.y"
{yyval.item=cfg_cat(yyvsp[-1].item,yyvsp[0].item);;
    break;}
case 18:
#line 218 "gpm-root.y"
{yyval.item=NULL;;
    break;}
case 19:
#line 219 "gpm-root.y"
{yyval.item= yyvsp[-1].item ? cfg_cat(yyvsp[-1].item,yyvsp[0].item) : yyvsp[0].item;;
    break;}
case 20:
#line 222 "gpm-root.y"
{yyval.item=cfg_makeitem('F',yyvsp[-1].string,yyvsp[0].fun, NULL);;
    break;}
case 21:
#line 223 "gpm-root.y"
{yyval.item=cfg_makeitem('2',yyvsp[-2].string,yyvsp[-1].fun, yyvsp[0].string);;
    break;}
case 22:
#line 224 "gpm-root.y"
{yyval.item=cfg_makeitem('M',yyvsp[-1].string,NULL,yyvsp[0].draw);;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 465 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 227 "gpm-root.y"
 /* end grammar ###########################################################*/

int yyerror(char *s){
  fprintf(stderr,"%s:%s(%i): %s\n",prgname,cfgname,cfglineno,s);
  return 1;
  }

int yywrap(){return 1;}

struct tokenName {
  char *name;
  int token;
  int value;
  };
struct tokenName tokenList[] = {
  {"foreground",T_FORE,0},
  {"background",T_BACK,0},
  {"border",    T_BORD,0},
  {"head",      T_HEAD,0},
  {"name",      T_NAME,0},
  {"button",    T_BUTTON,0},
  {"black",     T_COLOR,0},
  {"blue",      T_COLOR,1},
  {"green",     T_COLOR,2},
  {"cyan",      T_COLOR,3},
  {"red",       T_COLOR,4},
  {"magenta",   T_COLOR,5},
  {"yellow",    T_COLOR,6},
  {"white",     T_COLOR,7},
  {"bright",    T_BRIGHT,0},
  {NULL,0,0}
  };

struct funcName {
  char *name;
  int token;
  int (*fun)();
  };
struct funcName funcList[] = {
  {"f.debug",T_FUNC,f_debug},
  {"f.fgcmd",T_FUN2,f_fgcmd},
  {"f.bgcmd",T_FUN2,f_bgcmd},
  {"f.jptty",T_FUN2,f_jptty},
  {"f.mktty",T_FUNC,f_mktty},
  {"f.menu",T_FUNC,f_menu},
  {"f.lock",T_FUNC,f_lock},
  {"f.load",T_FUNC,f_load},
  {"f.free",T_FUNC,f_free},
  {"f.time",T_FUNC,f_time},
  {"f.pipe",T_FUN2,f_pipe},
  {"f.nop",T_FUNC,NULL},
  {NULL,0,NULL}
};

/*---------------------------------------------------------------------*/
int yylex()
{
int c,i;
char s[80];
struct tokenName *tn;
struct funcName *fn;

  while(1)
    {
    i=0;
    switch(c=getc(cfgfile))
      {
      case EOF: fclose(cfgfile); return 0;
      case '\"':
        do
	 {
	 s[i]=getc(cfgfile);
	 if ((s[i])=='\n')
	   {
	   yyerror("unterminated string");
	   cfglineno++;
	   }
	 if (s[i]=='\\') s[i]=getc(cfgfile);
	 }

        /* get '"' as '\"' */
	while (s[i++]!='\"' && s[i-2] !='\\')
	  ;
        s[i-1]=0; yylval.string=(char *)strdup(s); return T_STRING;

      case '#':
        while (c=getc(cfgfile)!='\n' && c!=EOF)
	  /* do nothing and fall through */ ;
      case '\n':
        cfglineno++;
        /* fall through */
      case ' ':
        case '\t': continue;

      default:
        if (!isalpha(c)) return(c);
      }
    /* get a single word and convert it */
    do
      s[i++]=c;
    while (isalnum(c=getc(cfgfile)) || c=='.');
    ungetc(c,cfgfile);
    s[i]=0;
    for (tn=tokenList; tn->name; tn++)
      if (tn->name[0]==s[0] && !strcmp(tn->name,s))
	{
	yylval.silly=tn->value; 
	return tn->token;
	}
    for (fn=funcList; fn->name; fn++)
      if (fn->name[0]==s[0] && !strcmp(fn->name,s))
	{
	yylval.fun=fn->fun; 
	return fn->token;
	}
    yylval.string=(char *)strdup(s); return T_STRING;
    }
} 

/*---------------------------------------------------------------------*/
void cfg_free(Draw *what)
{
Draw *ptr;
DrawItem *item;

  for (ptr=what; ptr; ptr=ptr->next)
    {
    if (ptr->title) free(ptr->title);
    for (item=ptr->menu; item; item=item->next)
      {
      if (item->name) free(item->name);
      if (item->arg) free(item->arg);
      if (item->type=='M' && item->clientdata)
	{
	((Draw *)(item->clientdata))->next=NULL; /* redundant */
	cfg_free(item->clientdata);
        }
      if (item->clientdata) free(item->clientdata);
      }
    }
}

/*---------------------------------------------------------------------*/
/* malloc an empty Draw */
Draw *cfg_alloc(void)
{
Draw *new=calloc(1,sizeof(Draw));

  if (!new) return NULL;
  new->back=DEFAULT_BACK;
  new->fore=DEFAULT_FORE;
  new->bord=DEFAULT_BORD;
  new->head=DEFAULT_HEAD;

  return new;
}

/*---------------------------------------------------------------------*/
/* malloc an empty DrawItem and fill it */
DrawItem *cfg_makeitem(int mode, char *msg, int(*fun)(), void *detail)
{
DrawItem *new=calloc(1,sizeof(DrawItem));

  if (!new) return NULL;

  new->name=(char *)strdup(msg);
  new->type=mode;
  switch(mode)
    {
    case '2': /* a function with one arg */
      new->arg=(char *)strdup(detail);
      /* fall through */

    case 'F': /* a function without args */
      new->fun=fun;
      if (fun) fun(F_CREATE,new);
      break;

    case 'M':
      new->clientdata=detail;
      break;

    default: fprintf(stderr,"%s: unknown item type (can't happen)\n",prgname);
    }

  return new;
}

/*---------------------------------------------------------------------*/
/* concatenate two item lists */
DrawItem *cfg_cat(DrawItem *d1, DrawItem *d2)
{
DrawItem *tmp;

  for (tmp=d1; tmp->next; tmp=tmp->next)
    ;
  tmp->next=d2;
  return d1;
}

/*====================================================================*/
void f__fix(struct passwd *pass)
{
  setgid(pass->pw_gid);
  setuid(pass->pw_uid);
  setenv("HOME",    pass->pw_dir, 1);
  setenv("LOGNAME", pass->pw_name,1);
  setenv("USER",    pass->pw_name,1);
}

/*---------------------------------------------------------------------*/
static int f_debug_one(FILE *f, Draw *draw)
{
DrawItem *ip;
static int tc=0;
int i,j;

#define LINE(args) for(i=0;i<tc;i++) putc('\t',f); fprintf args

  LINE((f,"BUTT %i - %ix%i\n",draw->buttons,draw->width,draw->height));
  LINE((f,"UID %i\n",draw->uid));
  LINE((f,"fore %i - back %i\n",draw->fore,draw->back));
  LINE((f,"bord %i - head %i\n",draw->bord,draw->head));
  LINE((f,"---> \"%s\" %li\n",draw->title,(long)(draw->mtime)));
  for (ip=draw->menu; ip; ip=ip->next)
    {
    LINE((f,"    %i \"%s\" (%p)\n",ip->type,ip->name,ip->fun));
    if (ip->fun == f_menu)
      {
      tc++; f_debug_one(f,(Draw *)ip->clientdata); tc--;
      }
    }
#undef LINE(args)
}

int f_debug(int mode, DrawItem *self, int uid)
{
FILE *f;
Draw *dp;

  switch (mode)
    {
    case F_POST:
      if (!(f=fopen("/tmp/root-debug","a"))) return 1;
      for(dp=drawList; dp; dp=dp->next)
	f_debug_one(f,dp);
      fprintf(f,"\n\n");
      fclose(f);

    case F_CREATE:
    case F_INVOKE:
      break;
    }
  return 0;
}


/*---------------------------------------------------------------------*/
int f_fgcmd(int mode, DrawItem *self, int uid)
{
int i;

  switch (mode)
    {
    case F_CREATE:
    case F_POST:
      break;
    case F_INVOKE:
      /* MISS */
    }
  return 0;
}

/*---------------------------------------------------------------------*/
int f_bgcmd(int mode, DrawItem *self, int uid)
{
int i;
struct passwd *pass;

  switch (mode)
    {
    case F_CREATE:
    case F_POST:
      break;
    case F_INVOKE:
      switch(fork())
	{
	case -1: PERROR("fork()"); return 1;

	case 0:
	  setuid(uid);
	  pass=getpwuid(uid);
	  if (!pass) exit(1);
	  f__fix(pass);
	  close(0); close(1); close(2);
	  open("/dev/null",O_RDONLY); /* stdin  */
	  open("/dev/tty0",O_WRONLY); /* stdout */
	  dup(1);                     /* stderr */  
	  for (i=3;i<OPEN_MAX; i++) close(i);
	  execl("/bin/sh","sh","-c",self->arg,(char *)NULL);
	  exit(1); /* shouldn't happen */

	default: return 0;

	}
    }
  return 0;
}
/*---------------------------------------------------------------------*/
int f_jptty(int mode, DrawItem *self, int uid)
{
int i,fd;

  switch (mode)
    {
    case F_CREATE:
    case F_POST:
      break;
    case F_INVOKE:
      i=atoi(self->arg);
      fd=open("/dev/tty0",O_RDWR);
      if (fd<0) {PERROR("/dev/tty0"); return 1;}
      if (ioctl(fd, VT_ACTIVATE, i)<0) {PERROR("ioctl()"); return 1;}
      return 0;
    }
}

/*---------------------------------------------------------------------*/
int f_mktty(int mode, DrawItem *self, int uid)
{
int fd;
long vc;
char name[10];
  switch (mode)
    {
    case F_CREATE:
      self->arg=malloc(8);
    case F_POST:
      break;
    case F_INVOKE:
      fd=open("/dev/tty0",O_RDWR);
      if (fd<0) {PERROR("/dev/tty0"); return 1;}
      if (ioctl(fd, VT_OPENQRY, &vc)<0) {PERROR("ioctl()"); return 1;}
      switch(fork())
	{
	case -1: PERROR("fork()"); return 1;

	case 0:
	  /* child: exec getty */
	  sprintf(name,"tty%i",vc);
	  execl("/sbin/agetty","agetty","38400",name,(char *)NULL);
	  exit(1); /* shouldn't happen */

        default:
	  /* father: jump to the tty */
	  sprintf(self->arg,"%i",vc);
	  return f_jptty(mode,self,uid);
	}
      return 0;
    }
}

/*---------------------------------------------------------------------*/
int f_menu(int mode, DrawItem *self, int uid){}

/*---------------------------------------------------------------------*/
int f_lock(int mode, DrawItem *self, int uid){}

/*---------------------------------------------------------------------*/
int f_load(int mode, DrawItem *self, int uid)
{
FILE *f;
double l1,l2,l3;

  switch (mode)
    {
    case F_CREATE: /* modify name, just to fake its length */
      self->clientdata=malloc(strlen(self->name)+20);
      self->name=realloc(self->name,strlen(self->name)+20);
      strcpy(self->clientdata,self->name);
      strcat(self->clientdata," %5.2f %5.2f %5.2f");
      sprintf(self->name,self->clientdata,l1,l2,l3);
      break;

    case F_POST:
      if (!(f=fopen("/proc/loadavg","r"))) return 1;
      fscanf(f,"%lf %lf %lf",&l1,&l2,&l3);
      sprintf(self->name,self->clientdata,l1,l2,l3);
      fclose(f);

    case F_INVOKE:
      break;
    }
  return 0;
}

/*---------------------------------------------------------------------*/
int f_free(int mode, DrawItem *self, int uid)
{
FILE *f;
long l1,l2;
char s[80];
  switch (mode)
    {
    case F_CREATE: /* modify name, just to fake its length */
      self->clientdata=malloc(strlen(self->name)+30);
      self->name=realloc(self->name,strlen(self->name)+30);
      strcpy(self->clientdata,self->name);
      strcat(self->clientdata," %5.2fM mem + %5.2fM swap");
      sprintf(self->name,self->clientdata,l1,l2);
      break;

    case F_POST:
      if (!(f=fopen("/proc/meminfo","r"))) return 1;
      fgets(s,80,f);
      fgets(s,80,f); sscanf(s,"%*s %*s %*s %li",&l1);
      fgets(s,80,f); sscanf(s,"%*s %*s %*s %li",&l2);
      sprintf(self->name,self->clientdata,
	      (double)l1/1024/1024,(double)l2/1024/1024);
      fclose(f);

    case F_INVOKE:
      break;
    }
  return 0;
}

/*---------------------------------------------------------------------*/
int f_time(int mode, DrawItem *self, int uid) {
char s[128];
struct tm *broken;
time_t t;

  time(&t); broken=localtime(&t);
  switch (mode)
    {
    case F_CREATE: /* modify name, just to fake its length */
      self->clientdata=self->name;
      strftime(s,110,self->clientdata,broken);
      strcat(s,"1234567890"); /* names can change length */       
      self->name=(char *)strdup(s);
      /* rewrite the right string */
      strftime(self->name,110,self->clientdata,broken);
      break;

    case F_POST:
      strftime(self->name,120,self->clientdata,broken);

    case F_INVOKE:
      break;
    }
  return 0;
}

/*---------------------------------------------------------------------*/
int f_pipe(int mode, DrawItem *self, int uid) {return 0;}

/*====================================================================*/
/* read menus from a file, and return a list or NULL */
Draw *cfg_read(int uid)
{
Draw *ptr;
DrawItem *item;
int hei,wid;

  if (!(cfgfile=fopen(cfgname,"r")))
    {
    PERROR(cfgname); return NULL;
    }
  DEBUG((stderr,"Reading file \"%s\"\n",cfgname));
  cfglineno=1;
  if (yyparse())
    {
    cfg_free(cfgall);
    cfgall=NULL;
    return NULL;
    }

  for (ptr=cfgall; ptr; ptr=ptr->next)
    {
    ptr->uid=uid;
    hei=0; wid= ptr->title? strlen(ptr->title)+2 : 0;

    /* calculate width and height */
    for (item=ptr->menu; item; item=item->next)
      {
      hei++;
      wid= wid > strlen(item->name) ? wid : strlen(item->name);
      }
    ptr->height=hei+2;
    ptr->width=wid+2;

    /* fix paddings */
    for (item=ptr->menu; item; item=item->next)
      item->pad=(ptr->width-strlen(item->name ? item->name : ""))/2;
    }

  return cfgall;
}


/*---------------------------------------------------------------------*/
/* the return value tells wether it has been newly loaded or not */
int getdraw(int uid, int buttons, time_t mtime1, time_t mtime2)
{
struct passwd *pass;
struct stat buf;
Draw *new, *np, *op, *pp;
int retval=0;
time_t mtime;

  DEBUGG((stderr,"getdraw: %i %i %li %li\n",uid,buttons,mtime1,mtime2));

  pass=getpwuid(uid);

  /* deny personal cfg to root for security reasons */
  if (pass==NULL || !uid || !opt_user) 
    {
    mtime=mtime2; uid=-1;
    strcpy(cfgname,SYSTEM_CFG);
    }
  else
    {
    mtime=mtime1;
    strcpy(cfgname,pass->pw_dir);
    strcat(cfgname,"/" USER_CFG);
    }

  if (stat(cfgname,&buf)==-1)
    {
    DEBUGG((stderr,"failed \"%s\"\n",cfgname)); 
    /* try the system wide */
    mtime=mtime2; uid = -1;
    strcpy(cfgname,SYSTEM_CFG);
    if (stat(cfgname,&buf)==-1)
      {PERROR(cfgname);return 0;}
    }

  if (buf.st_mtime <= mtime)
    return 0;
  
  /* else, read the new drawing tree */
  new=cfg_read(uid);
  if (!new) return 0;

  /* scan old data to remove duplicates */
  for (np=new; np; pp=np, np=np->next)
    {
    np->mtime=buf.st_mtime;
    if (np->buttons==buttons) retval++;
    for (op=drawList; op; op=op->next)
      if (op->uid==np->uid && op->buttons==np->buttons)
	op->buttons=0; /* mark for deletion */
    }

  /* chain in */
  pp->next=drawList; drawList=new;

  /* actually remove fake entries */
  for (np=drawList; np; pp=np, np=np->next)
    if (!np->buttons)
      {pp->next=np->next; np->next=NULL; cfg_free(np); np=pp;}
  return retval; /* found or not */
}


/*---------------------------------------------------------------------*/
Draw *retrievedraw(int uid, int buttons)
{
Draw *drawPtr, *genericPtr=NULL;
time_t mtime;

  /* retrieve a drawing by scanning the list */
  do
    {
    for (drawPtr=drawList; drawPtr; drawPtr=drawPtr->next)
      {
      if (drawPtr->uid==uid && drawPtr->buttons==buttons)
	break;
      if (drawPtr->uid==-1 && drawPtr->buttons==buttons)
	genericPtr=drawPtr;
      }
    }
  while (getdraw(uid,buttons,
		 drawPtr ? drawPtr->mtime : 0,
		 genericPtr ? genericPtr->mtime :0));


  return drawPtr ? drawPtr : genericPtr;
}


/*=====================================================================*/
int usage(void)
{
 printf( "(" GPM_NAME ") " GPM_RELEASE ", " GPM_DATE "\n"
        "Usage: %s [options]\n",prgname);
 printf("  Valid options are\n"
 "    -m <number-or-name>   modifier to use\n"
 "    -B <buffersize>       buffer to embed screendump\n"
 "                              (default is size of current screen)\n"
 );

  return 1;
}

/*------------*/
int getmask(char *arg, struct node *table)
{
int last=0, value=0;
char *cur;
struct node *n;

  if (isdigit(arg[0])) return atoi(arg);

  while (1)
    {
    while (*arg && !isalnum(*arg)) arg++; /* skip delimiters */
    cur=arg;
    while(isalnum(*cur)) cur++; /* scan the word */
    if (!*cur) last++;
    *cur=0;

    for (n=table;n->name;n++)
      if (!strcmp(n->name,arg))
    {
    value |= n->flag;
    break;
    }
    if (!n->name) fprintf(stderr,"%s: Incorrect flag \"%s\"\n",prgname,arg);
    if (last) break;

    cur++; arg=cur;
    }

  return value;
}

/*------------*/
int cmdline(int argc, char **argv, char *options)
{
int opt;
  
  while ((opt = getopt(argc, argv, options)) != -1)
    {
    switch (opt)
      {
      case 'm':  opt_mod=getmask(optarg, tableMod); break;
      case 'B':  opt_buf=atoi(optarg); break;
      case 'u':  opt_user=0;
      default:   return 1;
      }

    }
  return 0;
}

/*------------*/
static inline void scr_dump(int fd, char *buffer)
{
if (!usenewscrdump) 
  {
  fprintf(stderr,"%s: can't scrdump on kernels < 1.1.68\n",prgname);
  exit(1);
  }
buffer[0]=8;buffer[1]=0; /* new screendump, fgconsole */

if (ioctl(fd, TIOCLINUX,buffer)<0)
  {
  PERROR("ioctl(scrdump)");
  exit(1);
  }
buffer[buffer[0]*buffer[1]*2+4]='\0'; /* terminate the string */
}

/*------------*/
static inline void scr_restore(int fd, FILE *f, char *buffer)
{
int x,y;
/*
 * GOTOXY(f,0,0);
 * fputs(buffer+2,f);
 */

  x=buffer[2]; y=buffer[3];
  buffer[0]=9,buffer[1]=0; /* restore, current */
  if (ioctl(fd,TIOCLINUX,buffer)<0)
    {
    PERROR("ioctl(screstore)");
    exit(1);
    }
  GOTOXY(f,x+1,y+1);
}

/*===================================================================*/
/* post and unpost menus from the screen */
static int postcount;
static Posted *activemenu;

Posted *postmenu(int fd, FILE *f, Draw *draw, int x, int y)
{
Posted *new;
DrawItem *item;
char *dump;
int i;
short lines,columns;

  new=calloc(1,sizeof(Posted));
  if (!new) return NULL;
  new->draw=draw;
  new->dump=dump=malloc(opt_buf);
  scr_dump(fd,dump);
  lines=dump[0]; columns=dump[1];
  i=(columns*dump[3]+dump[2])*2+1; /* where to get it */
  if (i<0) i=1;
  new->colorcell=dump[4+i];
  DEBUGG((stderr,"Colorcell=%02x (at %i,%i = %i)\n",
		 new->colorcell,dump[2],dump[3],i));

  /* place the box relative to the mouse */
  if (!postcount) x -= draw->width/2; else x+=2;
  y++;

  /* fit inside the screen */
  if (x<1) x=1;
  if (x+draw->width >= columns) x=columns-1-draw->width;
  if (y+draw->height > lines+1) y=lines+1-draw->height;
  new->x=x; new->X=x+draw->width-1;
  new->y=y; new->Y=y+draw->height-1;

  /* top border */
  GOTOXY(f,x,y); BACKCOLOR(f,draw->back); FORECOLOR(f,draw->bord);
  putc('*',f); for (i=0; i<draw->width; i++) putc('=',f); putc('*',f);
  if (draw->title)
    {
    GOTOXY(f,x+(draw->width-strlen(draw->title))/2,y);
    FORECOLOR(f,draw->head);
    putc(' ',f); fputs(draw->title,f); putc(' ',f);
    }

  /* sides and items */
  for (item=draw->menu; y++, item; item=item->next)
    {
    if (item->fun) (*(item->fun))(F_POST,item);
    GOTOXY(f,x,y); FORECOLOR(f,draw->bord); putc('|',f);
    FORECOLOR(f,draw->fore);
    for (i=0;i<item->pad;i++) putc(' ',f);
    fputs(item->name,f); i+=strlen(item->name);
    while (i++<draw->width) putc(' ',f);
    FORECOLOR(f,draw->bord); putc('|',f);
    }

  /* bottom border */
  GOTOXY(f,x,y);
  putc('*',f); for (i=0; i<draw->width; i++) putc('=',f); putc('*',f);

  GOTOXY(f,new->dump[2]+1,new->dump[3]+1);
  fflush(f);
  
  /* and restore colors ASAP */
  FORECOLOR(f,new->colorcell&0xf);
  BACKCOLOR(f,(new->colorcell) >> 4);

  ioctl(fd,TCXONC,TCOOFF); /* inhibit further prints */  
  new->prev=activemenu;
  activemenu=new;
  postcount++;
  return new;
  }

Posted *unpostmenu(int fd, FILE *f, Posted *which)
{
Posted *prev=which->prev;

  scr_restore(fd,f,which->dump);
  ioctl(fd,TCXONC,TCOON); /* activate the console */  
  free(which->dump);
  free(which);
  activemenu=prev;
  postcount--;
  return prev;
}


void reap_children(int signo)
{
int status, pid;
pid=wait(&status);
DEBUG((stderr,"pid %i exited %i\n",pid,status));
}

/*===================================================================*/
int main(int argc, char **argv)
{
Gpm_Connect conn;
Gpm_Event ev;
int result, vc, fd,uid;
FILE *f, *ftmp;
struct stat stbuf;
Draw *draw;
DrawItem *item;
char *buffer;
char s[80];
int i,j,k, posty, postx, postX;
struct sigaction childaction;

  prgname=argv[0];

  if (getuid())
    {
    fprintf(stderr,"%s: Must be root\n", prgname);
    exit(1);
    }

  if (cmdline(argc,argv,"B:m:u"))
    exit(usage());

  /* reap your zombies */
  childaction.sa_handler=reap_children;
  childaction.sa_mask=0;
  childaction.sa_flags=SA_RESTART;
  sigaction(SIGCHLD,&childaction,NULL);

/*....................................... Connect and get your buffer */

  conn.eventMask=GPM_DOWN;
  conn.defaultMask=~GPM_DOWN; /* only button press */
  conn.maxMod=conn.minMod=opt_mod;

  gpm_zerobased=1;
  if (Gpm_Open(&conn,-1)==-1)
    {
    fprintf(stderr,"%s: can't open mouse connection\n",prgname);
    exit(1);
    }

  conn.eventMask=~0;
  conn.defaultMask=GPM_MOVE & GPM_HARD;
  conn.minMod=0;
  conn.maxMod=~0;

  chdir("/");

  if (!opt_buf)
    {
    if ((fd=open("/dev/console",O_RDONLY))<0)
      {
      fprintf(stderr,"%s: ",prgname); perror("/dev/console");
      exit(1);
      }
    ioctl(fd, TIOCGWINSZ, &win);
    opt_buf=win.ws_col*win.ws_row;
    close(fd);
    }
  opt_buf +=4; /* 2:size, 1:terminator, 1:alignment */
  if (usenewscrdump)
    opt_buf*=2; /* the new scrdump returns color info as well */

#if 0
  buffer=malloc(opt_buf);
  if (!buffer)
    {PERROR("malloc()"); exit(1);}
#endif

/*....................................... Go to background */

  switch(fork())
    {
    case -1: PERROR("fork()"); exit(1); /* error */
    case  0: break;                     /* child */
    default: exit(0);                   /* parent */
    }

  /* redirect stderr to /dev/console */
  if (!freopen("/dev/console","w",stderr))
    {
    printf("%s: freopen(stderr) failed\n", prgname); exit(1);
    }
  if (setsid()<0) {PERROR("setsid()"); exit(1);}
 
  openlog("gpm-root",LOG_CONS,LOG_USER);

/*....................................... Loop */

  while(Gpm_GetEvent(&ev)>0)
    {
    /* get rid of spurious events */
    if (ev.type&GPM_MOVE) continue; 

    vc=ev.vc;
    DEBUGG((stderr,"%s: event on console %i at %i, %i\n",
	   prgname,ev.vc,ev.x,ev.y));
    sprintf(s,"/dev/tty%i",ev.vc);
    if (stat(s,&stbuf)==-1) continue;
    uid = stbuf.st_uid;
    DEBUGG((stderr,"uid = %i\n",uid));

    draw=retrievedraw(uid,ev.buttons);
    if (!draw) continue;

    if (stat(s,&stbuf)==-1 || !(f=fopen(s,"r+"))) /* used to draw */
     {
     PERROR(s);
     continue;
     }
    
    if ((fd=open(s,O_RDWR))<0) /* will O_RDONLY be enough? */
      {
      PERROR(s);
      exit(1);
      }
    
    /* now change your connection information and manage the console */
    Gpm_Open(&conn,-1);
    uid=stbuf.st_uid;

    /* the task now is drawing the box from user data */
    postmenu(fd,f,draw,ev.x,ev.y);

    while(Gpm_GetEvent(&ev)>0 && ev.vc==vc)
      {
      Gpm_FitEvent(&ev);
      Gpm_DrawPointer(ev.x,ev.y,fd);
      if (ev.type&GPM_UP)
	break; /* we're done */
      }
    DEBUGG((stderr,"%i - %i\n",posty,ev.y));

    /* ok, redraw, close and return waiting */
    posty=activemenu->y;
    postx=activemenu->x;
    postX=activemenu->X;
    unpostmenu(fd,f,activemenu);
    close(fd);
    fclose(f);
    Gpm_Close();

    /* retrieve the item and invoke it */
    posty=ev.y-posty;
    if (postx<=ev.x && ev.x<=postX)
      {
      for (item=draw->menu; posty-- && item; item=item->next)
	;
      if (item && item->fun) (*(item->fun))(F_INVOKE,item,uid);
      }
    }
/*....................................... Done */

  while (Gpm_Close()) /* close all the stack */
    ;

  exit(0);
}

/*
 * This is because Linus uses 4-wide tabstops,
 * forcing me to use the same default to manage kernel sources
 */

/* Local Variables: */
/* tab-width:8      */
/* End:             */




