------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                 S Y S T E M . S E Q U E N T I A L _ I O                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the declaration of the control block used for
--  Seqential_IO. This must be declared at the outer library level. It also
--  contains code that is shared between instances of Sequential_IO.

with System.File_Control_Block;

package System.Sequential_IO is

   package FCB renames System.File_Control_Block;

   type Sequential_AFCB is new FCB.AFCB with null record;
   --  No additional fields required for Sequential_IO

   function AFCB_Allocate
     (Control_Block : Sequential_AFCB)
      return          FCB.AFCB_Ptr;

   procedure AFCB_Close (File : access Sequential_AFCB);
   procedure AFCB_Free  (File : access Sequential_AFCB);

   procedure Read
     (File : in out Sequential_AFCB;
      Item : out Ada.Streams.Stream_Element_Array;
      Last : out Ada.Streams.Stream_Element_Offset);
   --  Required overriding of Read, not actually used for Sequential_IO

   procedure Write
     (File : in out Sequential_AFCB;
      Item : in Ada.Streams.Stream_Element_Array);
   --  Required overriding of Write, not actually used for Sequential_IO

   type File_Type is access all Sequential_AFCB;
   --  File_Type in individual instantiations is derived from this type

   procedure Create
     (File : in out File_Type;
      Mode : in FCB.File_Mode := FCB.Out_File;
      Name : in String := "";
      Form : in String := "");

   procedure Open
     (File : in out File_Type;
      Mode : in FCB.File_Mode;
      Name : in String;
      Form : in String := "");

end System.Sequential_IO;
