//  LAST EDIT: Thu Mar  9 14:30:36 1995 by ekki(@prakinf.tu-ilmenau.de)
#ifndef __CONSTRAINTS_H__
#define __CONSTRAINTS_H__

#include "list.h"

#define DBM_OUT_VAR(c) (c->variables[c->methodOuts[c->whichMethod]])
#define DBM_WEAKER(a,b) (a>b)

#define DBM_MAX_VAR 10
#define DBM_NO_METHOD (-1)

class DB_Constraint;

extern const char* DBN_VARIABLE;

class DB_Variable: public RT_GeneralListEntry {
    friend class DB_List;
    friend class DB_Constraint;
    void removePropagateFrom(DB_List *); 
    void free();
    DB_Constraint *nextDownstreamConstraint(DB_List *);
    RT_String name;
  protected:
    DB_Boolean con;
  public:
    DB_List constraints;
    DB_Constraint *determinedBy; 
    long mark;
    DB_Strength walkStrength;
    DB_Boolean stay;

    DB_Variable(char *, DB_Boolean = FALSE); // if TRUE -> const 
    virtual ~DB_Variable();
    int isA(const char *_c) const { return RTM_isA(_c, DBN_VARIABLE ); }
    const char *get_name() const { return (char*)name; }
};

extern const char* DBN_CONSTRAINT;

class DB_Constraint: public RT_GeneralListEntry {
    friend class DB_Variable;
    friend class DB_List;
    DB_Boolean addPropagate();
    DB_Constraint *satisfy();
    int chooseMethod();
    void recalculate();
    DB_Boolean constantOutput();
    DB_Strength outputWalkStrength();
    DB_Boolean inputsKnown();
    void incrementalRemove();
  protected:
    void add();
  public:
    DB_Boolean inputFlag;
    DB_Strength strength;
    int whichMethod;
    int methodCount;
    int varCount;
    int methodOuts[DBM_MAX_VAR];
    DB_Variable	*variables[DBM_MAX_VAR];
    DB_List *extractPlanFromConstraint();
    void incrementalAdd();
    int satisfied() const { return whichMethod != DBM_NO_METHOD; }

    DB_Constraint(int, DB_Strength);
    virtual ~DB_Constraint();

    void print(FILE*) const;
    int isA(const char *_c) const { return RTM_isA(_c, DBN_CONSTRAINT ); }
    virtual void execute() = 0;
};

///// standard constraints:

class DB_StayC: public DB_Constraint {
    // keep variable constant 
    void execute() {}
  public:
    DB_StayC(DB_Variable *v, DB_Strength strength):DB_Constraint(1, strength) {
	variables[0] = v;
	methodCount = 1;
	methodOuts[0] = 0;
	add();
    }
};

class DB_EditC: public DB_Constraint {
    // change variable 
    void execute() {}
  public:
    DB_EditC(DB_Variable *v, DB_Strength strength):DB_Constraint(1, strength) {
	inputFlag = TRUE;
	variables[0] = v;
	methodCount = 1;
	methodOuts[0] = 0;
	add();
    }
};

///// some utilities:

char *DB_strength2string(DB_Strength);
DB_Strength DB_string2strength(char*);
// returns -1 if bad strength
extern char *DB_STRENGTH_NAMES[];

#endif

