////////////////////////////////////////////////////////////////////////////////
//  Computing of isolines and isoareas                                        //  
//  LAST EDIT: Fri Jun 17 09:08:36 1994 by Barth(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//	        yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <scient/2d_lat.h>

void RT_2DLattice::drawIso( int _pnr ) {
    if (!paramData[_pnr].loaded) return;
    switch ( iso.mode ) {
      case NO_ISO:
	delete_isolines();
	break;
      case ISO_LINES:
	isolines(_pnr);
	break;
      case ISO_AREAS:
	isoareas(_pnr);
	break;
    }
}

void RT_2DLattice::isolines( int pnr ) {
// computation of isolines
    int i, j, co[2];
    double v1[3], v2[3], v3[3], v4[3], vm[3];
    maxIsol = dims[0] * dims[1] * iso.nr * 2;
    delete_isolines();
    for ( i=0; i<maxIsol; i++ ) ilines[i] = 0;
    currIsol = 0;
    if ( pnr < 0 ) return;
    double pm;
    for ( i=0; i<dims[1]-1; i++ ) {
	for ( j=0; j<dims[0]-1; j++ ) {
	    co[1] = i;    co[0] = j;
	    getVertex(co, v1);
	    getParameter( pnr, j, i, &pm );
	    v1[2] = pm;
	    co[1] = i+1;    co[0] = j;
	    getVertex(co, v2);
	    getParameter( pnr, j, i+1, &pm );
	    v2[2] = pm;
	    co[1] = i;    co[0] = j+1;
	    getVertex(co, v3);
	    getParameter( pnr, j+1, i, &pm );
	    v3[2] = pm;
	    co[1] = i+1;    co[0] = j+1;
	    getVertex(co, v4);
	    getParameter( pnr, j+1, i+1, &pm );
	    v4[2] = pm;
	    vm[0] = 0.5 * (v1[0] + v3[0]);
	    vm[1] = 0.5 * (v1[1] + v2[1]);
	    vm[2] = 0.25 * (v1[2] + v2[2] + v3[2] + v4[2] );
	    tri_shift(v1, v3, vm );
	    tri_shift(v4, v3, vm );
	    tri_shift(v4, v2, vm );
	    tri_shift(v1, v2, vm );
	}
    }
}

void RT_2DLattice::tri_shift( double *v1, double *v2, double *v3 ) {
    double x[3], y[3], z[3];
    x[0] = v1[0]; x[1] = v2[0]; x[2] = v3[0];
    y[0] = v1[1]; y[1] = v2[1]; y[2] = v3[1];
    z[0] = v1[2]; z[1] = v2[2]; z[2] = v3[2];
    compute_line( x, y, z );
}

void RT_2DLattice::compute_line( double *x, double *y, double *z ) {
    int i, i0, i1, i2;
    double w, px[2], py[2], isoBase;

    if ( z[0] <= z[1] ) { i0=0; i1=1; }
    else { i0=1; i1=0; }

    if ( z[i1] <= z[2] ) { i2=2; }
    else { i2=i1; i1=2; }

    if ( z[i0] > z[i1] ) { i=i0; i0=i1; i1=i; }

    for ( i=0; i<iso.nr; i++ ) {
	if ( iso.realZ ) isoBase = iso.levels[i];
	else isoBase = 0.0;
	if (( z[i0] <= iso.levels[i] ) && ( iso.levels[i] < z[i2] )) {
	    w = ( iso.levels[i] - z[i0] ) / ( z[i2] - z[i0] );
	    px[0] = x[i0] + w * ( x[i2] - x[i0] );
	    py[0] = y[i0] + w * ( y[i2] - y[i0] );
	    if ( iso.levels[i] < z[i1] ) {
		w = ( iso.levels[i] - z[i0] ) / (z[i1] - z[i0] );
		px[1] = x[i0] + w * ( x[i1] -x[i0] );
		py[1] = y[i0] + w * ( y[i1] -y[i0] );
	    } else {
		w = ( iso.levels[i] - z[i1] ) / ( z[i2] - z[i1] );
		px[1] = x[i1] + w * ( x[i2] - x[i1] );
		py[1] = y[i1] + w * ( y[i2] - y[i1] );
	    }
	    RT_Vector pl[2];
	    pl[0] = RT_Vector( px[0], py[0], isoBase + iso.offset );
	    pl[1] = RT_Vector( px[1], py[1], isoBase + iso.offset );
	    ilines[ currIsol ] = new RT_Polyline( 0, 2, pl );
	    ilines[ currIsol ]->father( this );
	    ilines[ currIsol ]->emission( iso.colors[ i ] );
	    ilines[ currIsol ]->diffuse( iso.colors[ i ] );
	    ilines[ currIsol ]->specular( iso.colors[ i ] );
	    currIsol++;
	}
    }
    
}

void RT_2DLattice::delete_isolines() {
    if ( (ilines) && (currIsol) ) {
	for ( int i=0; i<=currIsol; i++ ) if ( ilines[i] ) delete ilines[i];
	delete ilines;
    }
    if (maxIsol) {
	ilines = new RT_Polyvertex*[maxIsol];
	for ( int i=0; i<maxIsol; i++ ) ilines[i] = 0;
    }
}

///////////////////////////////////////////////////////////////////////////////

void RT_2DLattice::isoareas( int pnr ) { 
// computation of isoareas
    int i, j, co[2];
    double v1[3], v2[3], v3[3], v4[3], vm[3];
    maxIsol = dims[0] * dims[1] * iso.nr * 2;
    delete_isolines();
    for ( i=0; i<maxIsol; i++ ) ilines[i] = 0;
    currIsol = 0;
    if ( pnr < 0 ) return;
    double pm;
    RT_Vector pts[4];
    for ( int inr=0; inr < iso.nr; inr ++ ) {
	for ( i=0; i<dims[1]-1; i++ ) {
	    for ( j=0; j<dims[0]-1; j++ ) {
		co[1] = i;    co[0] = j;
		getVertex(co, v1);
		getParameter( pnr, j, i, &pm );
		v1[2] = pm;
		co[1] = i+1;    co[0] = j;
		getVertex(co, v2);
		getParameter( pnr, j, i+1, &pm );
		v2[2] = pm;
		co[1] = i;    co[0] = j+1;
		getVertex(co, v3);
		getParameter( pnr, j+1, i, &pm );
		v3[2] = pm;
		co[1] = i+1;    co[0] = j+1;
		getVertex(co, v4);
		getParameter( pnr, j+1, i+1, &pm );
		v4[2] = pm;
		if ((v1[2]>=iso.levels[inr]) || (v2[2]>=iso.levels[inr]) || (v3[2]>=iso.levels[inr]) || (v4[2]>=iso.levels[inr])) 
		if ((v1[2]>=iso.levels[inr]) && (v2[2]>=iso.levels[inr]) && (v3[2]>=iso.levels[inr]) && (v4[2]>=iso.levels[inr])) {
		    pts[0] = RT_Vector(v1[0], v1[1], iso.levels[inr] );
		    pts[3] = RT_Vector(v2[0], v2[1], iso.levels[inr] );
		    pts[1] = RT_Vector(v3[0], v3[1], iso.levels[inr] );
		    pts[2] = RT_Vector(v4[0], v4[1], iso.levels[inr] );
		    ilines[currIsol] = new RT_Polygon( 0, 4, pts );
		    ilines[ currIsol ]->father( this );
		    ilines[ currIsol ]->emission( iso.colors[ inr ] );
		    ilines[ currIsol ]->diffuse( iso.colors[ inr ] );
		    ilines[ currIsol ]->specular( iso.colors[ inr ] );
		    ((RT_Polygon*)ilines[ currIsol ])->fillstyle( 1 );
		    ilines[ currIsol ]->referencing( attributes );
		    currIsol++;
		} else {
		    vm[0] = 0.5 * (v1[0] + v3[0]);
		    vm[1] = 0.5 * (v1[1] + v2[1]);
		    vm[2] = 0.25 * (v1[2] + v2[2] + v3[2] + v4[2] );
		    tri_area_shift(v1, v3, vm, inr );
		    tri_area_shift(v4, v3, vm, inr );
		    tri_area_shift(v4, v2, vm, inr );
		    tri_area_shift(v1, v2, vm, inr );
		}
	    }	
	}
    }
}

void RT_2DLattice::tri_area_shift( double *v1, double *v2, double *v3, int index ) {
    double x[3], y[3], z[3];
    x[0] = v1[0]; x[1] = v2[0]; x[2] = v3[0];
    y[0] = v1[1]; y[1] = v2[1]; y[2] = v3[1];
    z[0] = v1[2]; z[1] = v2[2]; z[2] = v3[2];
    compute_area( x, y, z, index );
}

void RT_2DLattice::compute_area( double *x, double *y, double *z, int index ) {
    int i, i0, i1, i2;
    double w, px[2], py[2], isoBase;
    RT_Vector pa[4];

    if (( z[0]<iso.levels[index] ) && ( z[1]<iso.levels[index] ) && ( z[2]<iso.levels[index] )) return;

    if (( z[0]>=iso.levels[index] ) && ( z[1]>=iso.levels[index] ) && ( z[2]>=iso.levels[index] )) {
	pa[0] = RT_Vector( x[0], y[0], iso.levels[index] );
	pa[1] = RT_Vector( x[1], y[1], iso.levels[index] );
	pa[2] = RT_Vector( x[2], y[2], iso.levels[index] );
	ilines[ currIsol ] = new RT_Polygon( 0, 3, pa );
	ilines[ currIsol ]->father( this );
	ilines[ currIsol ]->emission( iso.colors[ index ] );
	ilines[ currIsol ]->diffuse( iso.colors[ index ] );
	ilines[ currIsol ]->specular( iso.colors[ index ] );
	((RT_Polygon*)ilines[ currIsol ])->fillstyle( 1 );
	ilines[ currIsol ]->referencing( attributes );
	currIsol++;
	return;
    }

    if ( z[0] <= z[1] ) { i0=0; i1=1; }
    else { i0=1; i1=0; }

    if ( z[i1] <= z[2] ) { i2=2; }
    else { i2=i1; i1=2; }

    if ( z[i0] > z[i1] ) { i=i0; i0=i1; i1=i; }

    isoBase = iso.levels[index];
    if (( z[i0] <= iso.levels[index] ) && ( iso.levels[index] < z[i2] )) {
	w = ( iso.levels[index] - z[i0] ) / ( z[i2] - z[i0] );
	px[0] = x[i0] + w * ( x[i2] - x[i0] );
	py[0] = y[i0] + w * ( y[i2] - y[i0] );
	if ( iso.levels[index] < z[i1] ) {
	    w = ( iso.levels[index] - z[i0] ) / (z[i1] - z[i0] );
	    px[1] = x[i0] + w * ( x[i1] -x[i0] );
	    py[1] = y[i0] + w * ( y[i1] -y[i0] );
	} else {
	    w = ( iso.levels[index] - z[i1] ) / ( z[i2] - z[i1] );
	    px[1] = x[i1] + w * ( x[i2] - x[i1] );
	    py[1] = y[i1] + w * ( y[i2] - y[i1] );
	}
	int kk=0;
	for ( int k=0; k<3; k++ ) 
	    if ( z[k] >= iso.levels[index] ) {
		pa[kk] = RT_Vector( x[k], y[k], iso.levels[index] );
		kk++;
	    }
	pa[kk] = RT_Vector( px[1], py[1], iso.levels[index] );
	pa[kk+1] = RT_Vector( px[0], py[0], iso.levels[index] );
	ilines[ currIsol ] = new RT_Polygon( 0, kk+2, pa );
	ilines[ currIsol ]->father( this );
	ilines[ currIsol ]->emission( iso.colors[ index ] );
	ilines[ currIsol ]->diffuse( iso.colors[ index ] );
	ilines[ currIsol ]->specular( iso.colors[ index ] );
	((RT_Polygon*)ilines[ currIsol ])->fillstyle( 1 );
	ilines[ currIsol ]->referencing( attributes );
	currIsol++;
	RT_Vector swap = pa[kk]; pa[kk] = pa[kk+1]; pa[kk+1] = swap;
	ilines[ currIsol ] = new RT_Polygon( 0, kk+2, pa );
	ilines[ currIsol ]->father( this );
	ilines[ currIsol ]->emission( iso.colors[ index ] );
	ilines[ currIsol ]->diffuse( iso.colors[ index ] );
	ilines[ currIsol ]->specular( iso.colors[ index ] );
	((RT_Polygon*)ilines[ currIsol ])->fillstyle( 1 );
	ilines[ currIsol ]->referencing( attributes );
	currIsol++;
    }
}
