////////////////////////////////////////////////////////////////////////////////
//                                                                            //  
//  LAST EDIT: Thu Aug 11 13:46:20 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <unistd.h>
#include <yart.h>
#include <scient/scient.h>

#define MAX_IL 5

RT_PixmapDisplay *px;
RT_2DPerimetricLattice *plat;

int dx, dy;
double *tower, *wave, *xvec, *yvec;

void read_data() {
    char *rootpath = getenv( RT_GOOD_ROOT_DIR );
    char path[100], tow[100], wav[100], geo[100];
    sprintf(path, "%s%s", rootpath, "/packages/scient/data/");
// file with geometry data:
    sprintf(geo, "%s%s", path, "geom.lat" );
// two files with parameter data
    sprintf(tow, "%s%s", path, "tower.lat" );
    sprintf(wav, "%s%s", path, "wave1.lat" );

    FILE *fg = fopen(geo, "r");
    FILE *f = fopen(tow, "r");
    FILE *f2 = fopen(wav, "r");
    fscanf(fg,"%i %i",&dx, &dy );
    xvec = new double[ dx ];
    yvec = new double[ dy ];
    float x, y, z;
    for ( int i=0; i<dx; i++ ) { fscanf(fg, "%f", &x); xvec[i]=x* 0.5; }
    for ( i=0; i<dy; i++ ) { fscanf(fg, "%f", &y ); yvec[i] = y * 0.5; }

    tower = new double[ dx * dy ];
    for ( i=0; i<dx * dy; i++ ) { fscanf(f, "%f", &z ); tower[i] = z;  }
    int n=0;
    fclose( f );

    wave = new double[ dx * dy ];
    for ( i=0; i<dx * dy; i++ ) { fscanf(f2, "%f", &z ); wave[i] = z;  }
    fclose( f2 );
}


void initIsoLines( int pnr ) {
// Level and color for each isoline are specified here:
    double pmin, pmax, p, diff;
    plat->getParExtremes( pnr, &pmin, &pmax );
    diff = ( pmax - pmin ) / 11.0;
    p = pmin + diff;
    plat->isolevel(0, p, RT_Color(1, 0, 0 ) ); p += diff;
    plat->isolevel(1, p, RT_Color(0, 1, 0 ) ); p += diff;
    plat->isolevel(2, p, RT_Color(0, 1, 0 ) ); p += diff;
    plat->isolevel(3, p, RT_Color(1, 1, 0 ) ); p += diff;
    plat->isolevel(4, p, RT_Color(0, 1, 1 ) ); p += diff;
    plat->isolevel(5, p, RT_Color(1, 0, 1 ) ); p += diff;
    plat->isolevel(6, p, RT_Color(0, 1, 0 ) ); p += diff;
    plat->isolevel(7, p, RT_Color(0.5, 1, 0.5 ) ); p += diff;
    plat->isolevel(8, p, RT_Color(1, 0, 0.5 ) ); p += diff;
    plat->isolevel(9, p, RT_Color(0.5, 1, 0 ) );
}

int main() {
    RT_init();

    px = new RT_PixmapDisplay( "px", 500, 500 );
    px->singlebuffer();

    RT_Scene *sc = new RT_Scene("sc");

    read_data();
    
    sc->insert( plat = new RT_2DPerimetricLattice("plat") );
    plat->loadGeometry( dx, dy, xvec, yvec );
    plat->loadParameters( 1, RTSC_DOUBLE, tower );
    plat->loadParameters( 2, RTSC_DOUBLE, wave );

    RT_Light *ambSource;
    sc->insert( ambSource = new RT_AmbientLight( "al" ) );

    RT_LookatCamera *cam = new RT_LookatCamera("cam", RT_Vector( 5, 5, 15), RT_Vector(0,0,0));
    cam->zfar( 30 ); cam->angle( 60 );
    cam->pixmap( px );
    cam->scene( sc );
    cam->rendering();

    while (1) {
	initIsoLines( 1 );
	plat->map(1, Z_MAP );
	plat->map(1, ISO_MAP );
	plat->isomode( ISO_AREAS );
	plat->isobase( 0 );
	plat->isooffset( 0.01 );
	cam->rendering();
	sleep(5);

	plat->map( 1, ISO_MAP );
	plat->gridmode( NONE );
	plat->isomode( ISO_LINES );
	plat->isobase( 0 );
	plat->isooffset( 0.0 );
	cam->rendering();
	sleep(5);

	plat->isobase( 1 );
	cam->rendering();

	plat->isomode( ISO_AREAS );
	cam->rendering();
	sleep(5);

	plat->isomode( NO_ISO );
	plat->map( 1, NO_MAP );
	plat->map( 1, COLOR_MAP );
	plat->gridmode( FILLED );
	cam->rendering();
	sleep(5);

	plat->map(1, Z_MAP );
	cam->rendering();
	sleep(5);

	plat->map(1, ISO_MAP );
	plat->isomode( ISO_LINES );
	plat->isobase( 1 );
	plat->isooffset( 0.1 );
	cam->rendering();
	sleep(5);

	plat->map( 1, NO_MAP );
	plat->map( 2, NO_MAP );

/////////////////////////////////////////////////////////////////////////////

	plat->map(2, Z_MAP );
	plat->gridmode( HOLLOW );
	cam->rendering();
	sleep(5);

	initIsoLines( 2 );
	plat->map( 2, ISO_MAP );
	plat->gridmode( NONE );
	plat->isomode( ISO_LINES );
	plat->isobase( 0 );
	plat->isooffset( 0.0 );
	cam->rendering();
	sleep(5);

	plat->isobase( 1 );
	cam->rendering();

	plat->isomode( ISO_AREAS );
	cam->rendering();
	sleep(5);

	plat->isomode( NO_ISO );
	plat->map( 2, NO_MAP );
	plat->map( 2, COLOR_MAP );
	plat->gridmode( FILLED );
	cam->rendering();
	sleep(5);

	plat->map(2, Z_MAP );
	cam->rendering();
	sleep(5);

	plat->map( 1, NO_MAP );
	plat->map( 2, NO_MAP );

////////////////////////////////////////////////////////////////////////////
	plat->map(2, ISO_MAP );
	plat->isomode( ISO_AREAS );
	plat->isobase( 1 );
	plat->isooffset( 0.1 );
	cam->rendering();
	sleep(5);

	plat->map(1, ISO_MAP );
	plat->map(2, COLOR_MAP );
	plat->gridmode( FILLED );
	plat->isomode( ISO_AREAS );
	cam->rendering();
	sleep(5);


	plat->map(1, Z_MAP );
	cam->rendering();
	sleep(5);

	plat->map( 1, NO_MAP );
	plat->map( 2, NO_MAP );
    }
}



