////////////////////////////////////////////////////////////////////////////////
//  Implementation of the YART/VR front end input device.                     //  
//  LAST EDIT: Fri Nov  4 08:39:23 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART/VR extension. Copying, distribution and     //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright '94 '95 Ekkehard 'Ekki' Beier                                //
////////////////////////////////////////////////////////////////////////////////

#include "vr_yart.h"

const char *VRN_MANIPULATOR = "VR_Manipulator";

int VR_Manipulator::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a {ARG 1 Manipulator} object. The Manipulator device has to be coupled to a camera object.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 2) {
	    Tcl_AppendResult( ip, argv[0], ": Need exactly one argument.", 0 );
	    return TCL_ERROR;
	}
	new VR_Manipulator( argv[1] ); 
	RTM_classReturn;
    }
    return res; 
}

void VR_Manipulator::event(RT_Event *ev) {
    if (!ev || !get_camera()) return;

    if (ev->isA( RTN_BUTTON_EVENT )) {
	xtime = ev->getTime();
	RT_ButtonEvent &bev = *(RT_ButtonEvent*)ev;
	oldx = bev.x/((double)bev.w);
	oldy = bev.y/((double)bev.h);
	if (bev.left && !bev.shift ) {
	    RT_Ray r;
	    RT_Primitive *prim;
	    get_camera()->buildRay( oldx, oldy, r);
	    prim = get_camera()->getPrimitive( r );
	    if (prim && prim->get_pickmode() != RTE_NOT_PICKABLE ) {
		while ( prim->get_pickmode() == RTE_PICK_FATHER && prim->get_father() )
		    prim = prim->get_father();
		RT_String s( 30 );
		s = "pick ";
		s += RT_eval( "set vr_UID" );
		s += ' ';
		s += prim->get_name();
		vr_UserCommunicator->send( s );
	    }
	}
    } 
    if (ev->isA( RTN_MOTION_EVENT )) {
	xtime = ev->getTime();
	RT_MotionEvent &mev = *(RT_MotionEvent*)ev;
	double dx,dy,x,y;
	x = mev.x/((double)mev.w );
	y = mev.y/((double)mev.h );
	dx = x - oldx;
	dy = y - oldy;
	oldx = x;
	oldy = y;

	if ( mev.right ) {
	    RT_String cmd( 30 );
	    char dstr[10];
	    if (fabs( dx ) > 0.002) {
		cmd = "rotate ";
		cmd += RT_eval( "set vr_UID" );
		cmd += ' ';
		RT_double2string( -10. * dx, dstr );
		cmd += dstr;
		cmd += ';';
	    }
	    if (fabs( dy ) > 0.002) {
		cmd += mev.middle ? "upward " : "forward ";
		cmd += RT_eval( "set vr_UID" );
		cmd += ' ';
		RT_double2string( mev.middle ? dy : 10. * dy, dstr );
		cmd += dstr;
	    }
	    if (fabs( dx ) > 0.002 || fabs( dy ) > 0.002)
		vr_UserCommunicator->send( cmd );
	}
    }
}
