################################################################################
##  Tk based output of messages, errors, etc.                                 ##  
##  LAST EDIT: Thu Aug  4 10:29:42 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

Tcl_Object IOM_Error "" {} {Name} {String} \
{Creates a new tcl error object called {ARG 1 Name}.} \
{}

Tcl_Method IOM_Error ~IOM_Error {} {} {Destructor of object} {}

# the default error methodes:

Tcl_Method IOM_Error -special String String {The special message method of the error object put the {ARG 1 String} in the stdout stream.} {
    
    if {"$String"==""} return
    if {""==[info commands iom_output]} "IOM_TkError iom_output"
    if [catch "iom_output -special {$String}"] {
	puts stdout "Error special: $String" }
}

Tcl_Method IOM_Error -message String String {The message method of the error object put the {ARG 1 String} in the stdout stream.} {
    
    if {"$String"==""} return
    if {""==[info commands iom_output]} "IOM_TkError iom_output"
    if [catch "iom_output -message {$String}"] {
	puts stdout "Error message: $String"}
}

Tcl_Method IOM_Error -warning String String {The warning message method of the error object put the {ARG 1 String} in the stdout stream.} {

    if {"$String"==""} return
    if {""==[info commands iom_output]} "IOM_TkError iom_output"
    if [catch "iom_output -warning {$String}"] {
	puts stdout "Error warning: $String"}
}

Tcl_Method IOM_Error -error String String {The error message method of the error object put the {ARG 1 String} in the stdout stream.} {

    if {"$String"==""} return
    if {""==[info commands iom_output]} "IOM_TkError iom_output"
    if [catch "iom_output -error {$String}"] {
	puts stdout "Error error: $String"}
}

Tcl_Method IOM_Error -fatal String String {The fatal message method of the error object put the {ARG 1 String} in the stdout stream.} {

    if {"$String"==""} return
    if {""==[info commands iom_output]} "IOM_TkError iom_output"
    if [catch "iom_output -fatal {$String}"] {
	puts stdout "Error fatal: $String"}
}


IOM_TopBox ?
Tcl_Object IOM_TkError IOM_TopBox {} {Name} {String} \
	{Creates a new tk error object called {ARG 1 Name}.} \
	{
    set top  [set $THIS->tkTop]
    
    # the default error methodes
    wm minsize $top 350 100
    wm maxsize $top 1024 1024
    wm geometry $top 350x100
    wm title $top IOM.state	

    set path [set $THIS->frCenter]
    label $path.lb -relief raised -borderw 1 
    label $path.ln -relief raised -borderw 1 
    
    frame $path.f -relief raised -borderw 1
    text  $path.f.t \
	    -exportselection {false}\
	    -yscrollcommand "$path.f.s set"\
	    -borderw 4 -wrap word
    
    scrollbar $path.f.s -command "$path.f.t yview"  \
	    -relief sunken -borderw 1 -width 10
    
    pack $path.f.s -side right -fill y 
    pack $path.f.t -fill both -expand 1
    
    bind $path.f.t <Any-Key> { } 
    bind $path.f.t <Any-Button> { } 
    
    place $path.lb -anchor center \
	    -relx 0.12 \
	    -rely 0.335 \
	    -relwidth 0.19 \
	    -relheight 0.47
    
    place $path.ln -anchor center \
	    -relx 0.12 \
	    -rely 0.75 \
	    -relwidth 0.19 \
	    -relheight 0.3
    
    place $path.f -anchor center \
	    -relx 0.60 \
	    -rely 0.5 \
	    -relwidth 0.75 \
	    -relheight 0.80
    # the text tags 
    $path.f.t tag configure special -foreground blue
    $path.f.t tag configure message -foreground green 
    $path.f.t tag configure warning -foreground yellow 
    $path.f.t tag configure error   -background black -foreground red 
    $path.f.t tag configure fatal   -background red -foreground white
    
    # the buttons
    set path [set $THIS->frBottom]
    button $path.bc -text Clear -command "[set $THIS->frCenter].f.t delete 0.0 end"
    button $path.bt -text "Error Trace" -command errorTrace
    button $path.bq -text Close -command "delete $THIS"

    pack $path.bc -fill x -expand 1 -side left
    pack $path.bt -fill x -expand 1 -side left
    pack $path.bq -fill x -expand 1 -side left
    update
    # replacing this update will cause a core dump on Tk3.6
}

Tcl_Method IOM_TkError ~IOM_TkError {} {} {Destructor of object} {}

Tcl_Method IOM_TkError -special String String {The special message method of the error object put the {ARG 1 String} in the stdout stream.} {

    if {"$String"==""} return
    set path [set $THIS->frCenter]
    set start [$path.f.t index insert] 

    #$path.f.t yview -pickplace insert ### see AFTER_COMMENT
    set ip [$path.f.t index insert]
    after 100 "$path.f.t yview -pickplace $ip"
    
    $path.f.t insert insert "$String\n"
    set end [$path.f.t index insert] 
    $path.f.t tag add special "$start" "$end-1c"
    $path.ln configure -text Special -foreground blue
    $path.lb configure -bitmap info -foreground blue
}

Tcl_Method IOM_TkError -message String String {The message method of the error object put the {ARG 1 String} in the stdout stream.} {
    
    if {"$String"==""} return
    set path [set $THIS->frCenter]
    set start [$path.f.t index insert] 
    
    #$path.f.t yview -pickplace insert ### see AFTER_COMMENT
    set ip [$path.f.t index insert]
    after 100 "$path.f.t yview -pickplace $ip"
    
    $path.f.t insert insert "$String\n"
    set end [$path.f.t index insert] 
    $path.f.t tag add message "$start" "$end-1c"
    $path.ln configure -text Message -foreground green
    $path.lb configure -bitmap info -foreground green
}

Tcl_Method IOM_TkError -warning String String {The warning message method of the error object put the {ARG 1 String} in the stdout stream.} {
    
    if {"$String"==""} return
    set path [set $THIS->frCenter]
    set start [$path.f.t index insert] 
    
    #$path.f.t yview -pickplace insert ### see AFTER_COMMENT
    set ip [$path.f.t index insert]
    after 100 "$path.f.t yview -pickplace $ip"
    
    $path.f.t insert insert "$String\n" 
    set end [$path.f.t index insert] 
    $path.f.t tag add warning "$start" "$end-1c"
    $path.ln configure -text Warning -foreground yellow
    $path.lb configure -bitmap warning -foreground yellow
}

Tcl_Method IOM_TkError -error String String {The error message method of the error object put the {ARG 1 String} in the stdout stream.} {
    
    if {"$String"==""} return
    set path [set $THIS->frCenter]
    set start [$path.f.t index insert] 
    
    #$path.f.t yview -pickplace insert ### see AFTER_COMMENT
    set ip [$path.f.t index insert]
    after 100 "$path.f.t yview -pickplace $ip"
    
    $path.f.t insert insert "$String\n"
    set end [$path.f.t index insert] 
    $path.f.t tag add error "$start linestart" "$end lineend-1c"
    $path.ln configure -text Error -foreground red  
    $path.lb configure -bitmap error -foreground red
}

Tcl_Method IOM_TkError -fatal String String {The fatal message method of the error object put the {ARG 1 String} in the stdout stream.} {
    
    if {"$String"==""} return
    set path [set $THIS->frCenter]
    set start [$path.f.t index insert] 
    
    #$path.f.t yview -pickplace insert ### see AFTER_COMMENT
    set ip [$path.f.t index insert]
    after 100 "$path.f.t yview -pickplace $ip"
    
    $path.f.t insert insert "$String\n" 
    set end [$path.f.t index insert] 
    $path.f.t tag add fatal "$start linestart" "$end lineend-1c" 
    $path.ln configure -text Fatal -foreground red 
    $path.lb configure -bitmap error -foreground red
}

#AFTER_COMMENT:
# The following script dumps on Tk3.6 when performed in batch mode:

#proc p args {}
#text .t -yscrollcommand p
#.t yview -pickplace insert
#.t insert insert "test\n"

# CHANGED: $path.f.t yview -pickplace insert ### see AFTER_COMMENT

# TO: set ip [$path.f.t index insert]
# after 100 "$path.f.t yview -pickplace $ip"

