################################################################################
##  A user interface to the YART manipulator device.                          ##  
##  LAST EDIT: Thu Feb  9 18:02:05 1995 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_TopBox ?

Tcl_Object IOM_ManipulatorBox IOM_CmpTopBox {updateCommands xCameraName } {Name} {String} {Create a new manipulator box, to define a user interface for the manipulator device.} {
    catch "wm minsize [set $THIS->tkTop] 150 100"
    catch "wm maxsize [set $THIS->tkTop] 1200 1024"
    
    $THIS -buildCurrentObjectLabel
    wm title [set $THIS->tkTop] "IOM.manipulator"
    
    # set the wPath to the path of the center frame:
    set p [set $THIS->frCenter] 
    frame $p.kameras
    pack append $p $p.kameras {fill expand}
    
    set $THIS->xCameraName iom_Camera
    set camName [set $THIS->xCameraName]

    TKCamera $p.kameras $camName 
    $camName -znear 0.1 -zfar 50 -angle 20
    
    Manipulator $THIS.manipulator
    $THIS.manipulator -father $camName 

    frame $p.1
    frame $p.2

    pack append $p \
	    $p.1 {fill }\
	    $p.2 {fill }
    
    append refreshCMDs "[makeEnumButton $p.1 b1 $THIS.manipulator transformation];"
    append refreshCMDs "[makeEnumButton $p.1 b0 $THIS.manipulator axis];" 
    append refreshCMDs "[makeEnumButton $p.1 b2 $THIS.manipulator mode];" 
    append refreshCMDs "[makeEnumButton $p.1 b3 $THIS.manipulator box];"
    append refreshCMDs "[makeEnumButton $p.1 b4 $THIS.manipulator drawStyle];"

    append refreshCMDs "[makeEnumButton $p.2 b1 $THIS.manipulator autoUpdate];"
    append refreshCMDs "[makeButton $p.2 b2 $THIS.manipulator raytrace];"
    append refreshCMDs "[makeButton $p.2 b4 $THIS.manipulator resetMatrix];"
    append refreshCMDs "[2buttonValuator $p.2 b5 $THIS.manipulator sensibility];"
    set $THIS->updateCommands $refreshCMDs

    # Now set the callback procedure to update the interface after
    # each manipulator status change.
    $THIS.manipulator -addCB "$THIS -manipulatorDeviceCB"
    
    $THIS -addMenuSeparator options
    $THIS -addMenuEntry options "CameraControl" "$THIS -buildInterfaceDevice IOM_CameraBox $THIS.camera; $THIS.camera -currentCamera $camName; "
  $THIS -addMenuEntry options "VertexEditor" "regsub -all {\\.} \[$THIS -get_currentObject\] - name;\
	$THIS -buildInterfaceDevice IOM_VertexEditor vt\$name;\
	vt\$name -camera $camName"
    $THIS -addMenuSeparator help
    $THIS -addMenuEntry help "LookatCamera" "$THIS -buildInterfaceDevice IOM_ManualBox _i.man;
_i.man -manpage LookatCamera"	
    $THIS -addMenuEntry help "Manipulator" "$THIS -buildInterfaceDevice IOM_ManualBox _i.man;
_i.man -manpage Manipulator"	
}

Tcl_Method IOM_ManipulatorBox ~IOM_ManipulatorBox {} {} {Destructor} {
    delete $THIS.manipulator
}

Tcl_Method IOM_ManipulatorBox -update {} {} {Update the data representation of the widgets.} {
    $THIS.manipulator -currentObject [set $THIS->xcurrentObject]
    eval [set $THIS->updateCommands]
    [$THIS.manipulator -get_camera] -rendering
}

Tcl_Method IOM_ManipulatorBox -manipulatorDeviceCB {Device}\
  {String} {The manipulator device callback procedure to handle the status changes of the device. {ARG 1 Device} is the Name of the Manipulator.} \
{
    $THIS -currentObject [$Device -get_currentObject]
    eval [set $THIS->updateCommands]
}

Tcl_Method IOM_ManipulatorBox  -get_camera {} {}  {Get the camera name of the manipulator.} \
{ 
    return [set $THIS->xCameraName]
}

IOM_ManipulatorBox  -description {This is the class of the basic 3D manipulation interface. It is an front end to the YART class Manipulator. Additionally the interface has some menus and buttons to create the other interface boxes of the IOM user interface. }

IOM_ManipulatorBox  -keywords {IOM Userinterface Manipulator}



