################################################################################
##  This is the frame subclass to use with the placer for its children.       ##  
##  LAST EDIT: Thu Aug  4 10:48:37 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_Frame ?

# xChildren: the list of the child widgtes
# xMode    : the current layout mode
# xModes   : the list of the posible layout's

Tcl_Object IOM_Placer IOM_Frame {xChildren xMode xModes} {Name} {String} {Build a Frame widget with placed child widgets.} {}

Tcl_Method IOM_Placer ~IOM_Placer {} {} {Destroy the widget} {
    foreach cld [set $THIS->xChildren] {
	destroy $cld
    }
}

Tcl_Method IOM_Placer -mode {Value} {Integer} {Set the mode of the placer to the {ARG 1 Value}. The value must be one of the layout values described in the sub class of placer. } {
    if -1!=[lsearch [set $THIS->xModes] $Value] {
	set $THIS->xMode $Value }
	$THIS -place
}

Tcl_Method IOM_Placer -nextMode {} {} {Set next mode of the placer.} {
    set modes [set $THIS->xModes]
    
    set num [lsearch  $modes [set $THIS->xMode] ] 
    incr num;
    if $num==[llength $modes]  {
	set $THIS->xMode [lindex $modes 0]
    } {
	set $THIS->xMode [lindex $modes $num]
    }
    $THIS -place
}

Tcl_Method IOM_Placer -get_mode {} {} {Get the value of the current placer mode.} {
    return [set $THIS->xMode]
}

Tcl_Method IOM_Placer -unplace {} {} {Remove widgets from the frame.}  {
    foreach cld [set $THIS->xChildren] {
	place forget $cld
    }
}

Tcl_Method IOM_Placer -place {} {} {Place the widgets to the frame. The way of placing is detected by the current mode of the placer. This is the basic method of place und must be defind in the subclasses to manage the children.}  {
    $THIS -unplace
   case [set $THIS->xMode] in {
	default   {}
    }
}


IOM_Placer -description {A base class for all widget with variable layout options.}

IOM_Placer -keywords {IOM User-Interface}
