################################################################################
##  An advanced scale widget.                                                 ##  
##  LAST EDIT: Thu Aug  4 10:55:18 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_Placer ?

Tcl_Object IOM_EScale IOM_Placer {xMode xMin xMax xVal xBorderMin xBorderMax xGetCommand xSetCommand} {Name} {String} {Build the widget {ARG 1 Name}} {

    set $THIS->xModes {entry small middle full all}
    
    set $THIS->xMin 0.0
    set $THIS->xVal 0.0
    set $THIS->xMax 1.0

    set $THIS->xBorderMin 0.0
    set $THIS->xBorderMax 100.0
    
    
    button .$THIS.l -command "$THIS -nextMode" -border 1 
    
    button .$THIS.bMax -command "$THIS -setMaxToBorder" -relief flat \
	    -text  [set $THIS->xBorderMax]
    button .$THIS.bMin -command "$THIS -setMinToBorder" -relief flat \
	    -text  [set $THIS->xBorderMin]
    
    button .$THIS.valToMin -command "$THIS -setValToMin" -relief flat \
	    -text  "<-"
    button .$THIS.valToMax -command "$THIS -setValToMax" -relief flat \
	    -text  "->"
    
    scale .$THIS.s -orient horizontal -showvalue 0 -width 6 \
	    -sliderlength 20 -from 0 -to 1000 -command "$THIS -scaleCallback"
    
    frame .$THIS.min -relief sunken -border 1
    frame .$THIS.max -relief sunken -border 1
    frame .$THIS.val -relief sunken -border 1

    entry .$THIS.min.e 
    bind .$THIS.min.e <Key-Return> "$THIS -minCallback" 
    .$THIS.min.e insert 0 [set $THIS->xMin]
    
    entry .$THIS.max.e 
    bind .$THIS.max.e <Key-Return> "$THIS -maxCallback" 
    .$THIS.max.e insert 0 [set $THIS->xMax]
    
    entry .$THIS.val.e 
    bind .$THIS.val.e <Key-Return> "$THIS -valCallback" 
    .$THIS.val.e insert 0 [set $THIS->xVal]

    place .$THIS.min.e -anchor center \
	    -relx 0.5 -rely 0.5 -relwidth 0.9 -relheight 0.9
    place .$THIS.val.e -anchor center \
	    -relx 0.5 -rely 0.5 -relwidth 0.9 -relheight 0.9
    place .$THIS.max.e -anchor center \
	    -relx 0.5 -rely 0.5 -relwidth 0.9 -relheight 0.9
    
    .$THIS configure -height 60 -width 250
    
    # set the list of the child widgets
    set $THIS->xChildren ".$THIS.l .$THIS.s .$THIS.min .$THIS.max .$THIS.bMax  .$THIS.bMin .$THIS.valToMin  .$THIS.valToMax .$THIS.val "
    
    # set the default mode
    $THIS -mode full
    # place the child widgets
    $THIS -place
}

Tcl_Method IOM_EScale -place {} {} {Place the widgets to the frame. The way of placing is detected by the current mode of the extendet scale}  {
    $THIS -unplace
    case [set $THIS->xMode] in {
	full   {
	    place .$THIS.l -anchor center \
		    -relx 0.1 \
		    -rely 0.5 \
		    -relwidth 0.16 \
		    -relheight 0.8
	    
	    place .$THIS.s -anchor center \
		    -relx 0.6 \
		    -rely 0.2 \
		    -relwidth 0.76 \
		    -relheight 0.16
	    
	    place .$THIS.min -anchor center \
		    -relx 0.33 \
		    -rely 0.7 \
		    -relwidth 0.2 \
		    -relheight 0.5
	    
 	    place .$THIS.val -anchor center \
		    -relx 0.6 \
		    -rely 0.7 \
		    -relwidth 0.25 \
		    -relheight 0.5
	    
	    place .$THIS.max -anchor center \
		    -relx 0.87 \
		    -rely 0.7 \
		    -relwidth 0.2 \
		    -relheight 0.5
	}
	all   {
	    place .$THIS.l -anchor center \
		    -relx 0.1 \
		    -rely 0.5 \
		    -relwidth 0.16 \
		    -relheight 0.8

	    place .$THIS.s -anchor center \
		    -relx 0.6 \
		    -rely 0.2 \
		    -relwidth 0.76 \
		    -relheight 0.16
	    
 	    place .$THIS.val -anchor center \
		    -relx 0.6 \
		    -rely 0.575 \
		    -relwidth 0.25 \
		    -relheight 0.2
	    
 	    place .$THIS.valToMin -anchor center \
		    -relx 0.55 \
		    -rely 0.825 \
		    -relwidth 0.1 \
		    -relheight 0.2
	    
 	    place .$THIS.valToMax -anchor center \
		    -relx 0.65 \
		    -rely 0.825 \
		    -relwidth 0.1 \
		    -relheight 0.2
	    
	    place .$THIS.min -anchor center \
		    -relx 0.33 \
		    -rely 0.575 \
		    -relwidth 0.2 \
		    -relheight 0.2

	    place .$THIS.max -anchor center \
		    -relx 0.87 \
		    -rely 0.575 \
		    -relwidth 0.2 \
		    -relheight 0.2

	    place .$THIS.bMin -anchor center \
		    -relx 0.33 \
		    -rely 0.825 \
		    -relwidth 0.2 \
		    -relheight 0.2
	    
	    place .$THIS.bMax -anchor center \
		    -relx 0.87 \
		    -rely 0.825 \
		    -relwidth 0.2 \
		    -relheight 0.2
	}
	    
	middle {	    
	    place .$THIS.val -anchor center \
		    -relx 0.6 \
		    -rely 0.7 \
		    -relwidth 0.76 \
		    -relheight 0.5
	    
	    place .$THIS.l -anchor center \
		    -relx 0.1 \
		    -rely 0.5 \
		    -relwidth 0.16 \
		    -relheight 0.8
	    
	    place .$THIS.s -anchor center \
		    -relx 0.6 \
		    -rely 0.2 \
		    -relwidth 0.76 \
		    -relheight 0.16
	}
	small  {
	    place .$THIS.l -anchor center \
		    -relx 0.1 \
		    -rely 0.5 \
		    -relwidth 0.16 \
		    -relheight 0.8
	    
	    place .$THIS.s -anchor center \
		    -relx 0.6 \
		    -rely 0.5 \
		    -relwidth 0.76 \
		    -relheight 0.8
	}	
	entry {	    
	    place .$THIS.val -anchor center \
		    -relx 0.6 \
		    -rely 0.5 \
		    -relwidth 0.76 \
		    -relheight 0.8
	    
	    place .$THIS.l -anchor center \
		    -relx 0.1 \
		    -rely 0.5 \
		    -relwidth 0.16 \
		    -relheight 0.8
	}
    }
}

Tcl_Method IOM_EScale -scaleCallback {Value} {Integer} {Callculate the new value of val from the scale {ARG 1 Value}.} {
    set min [set $THIS->xMin]
    set max [set $THIS->xMax]
    set $THIS->xVal [expr $min+($max-$min)/1000*$Value]
    .$THIS.val.e delete 0 end
    .$THIS.val.e insert 0 [set $THIS->xVal]
    $THIS -callUpdateCMD
}

Tcl_Method IOM_EScale -setScale {} {} {Set the scale position to the position defined by the min, val und max values.} {
    # get the values:
    set val [set $THIS->xVal]
    set min [set $THIS->xMin]
    set max [set $THIS->xMax]
    
    if $min!=$max {
	.$THIS.s set [format %.0f [expr ($val-$min)/($max-$min)*1000]]
    } {
	.$THIS.s set 500
    }
}

Tcl_Method IOM_EScale -minCallback {} {} {This is the trace method for the min member variable.} {
    # get the entry string
    set val [.$THIS.min.e get]

    if [scan $val %f tmp] {
	# clear the float string
	set tmp [expr $tmp*1.0]

	if $tmp>[set $THIS->xBorderMin] {
	    if $tmp<[set $THIS->xMax] {
		set $THIS->xMin    $tmp 
	    } {
		set $THIS->xMin    [set $THIS->xMax]
	    }
	} {
	    set $THIS->xMin    [set $THIS->xBorderMin]
	}
    }
    # reset the entry
    .$THIS.min.e delete 0 end
    .$THIS.min.e insert 0 [set $THIS->xMin]
    $THIS -setScale
}

Tcl_Method IOM_EScale -maxCallback {} {} {This is the trace method for the max member variable.} {
    # get the entry string
    set val [.$THIS.max.e get]
    
    if [scan $val %f tmp] {
	if $tmp<[set $THIS->xBorderMax] {
	    if $tmp>[set $THIS->xMin] {
		set $THIS->xMax    $tmp 
	    } {
		set $THIS->xMax    [set $THIS->xMin]
	    }
	} {
	    set $THIS->xMax    [set $THIS->xBorderMax]
	}
    }
    # reset the entry
    .$THIS.max.e delete 0 end
    .$THIS.max.e insert 0 [set $THIS->xMax]
    $THIS -setScale
}

Tcl_Method IOM_EScale -valCallback {} {} {This is the trace method for the val member variable.} {
    # get the entry string
    set val [.$THIS.val.e get]
    set min [set $THIS->xMin]
    set max [set $THIS->xMax]
    
    if [scan $val %f tmp] {
	if $tmp>$min&&$tmp<$max {
	    set $THIS->xVal    $tmp 
	    $THIS -setScale
	    $THIS -callUpdateCMD
	}
    }
    # reset the entry
    .$THIS.val.e delete 0 end
    .$THIS.val.e insert 0 [set $THIS->xVal]
}

Tcl_Method IOM_EScale -setMaxToBorder {} {} {Set the maximal scale value to the border value.} {
    set $THIS->xMax [set $THIS->xBorderMax]
    .$THIS.max.e delete 0 end
    .$THIS.max.e insert 0 [set $THIS->xBorderMax]
    $THIS -setScale
}
    
Tcl_Method IOM_EScale -setMinToBorder {} {} {Set the minimal scale value to the border value.} {
    set $THIS->xMin [set $THIS->xBorderMin]
    .$THIS.min.e delete 0 end
    .$THIS.min.e insert 0 [set $THIS->xBorderMin]
    $THIS -setScale
}

Tcl_Method IOM_EScale -setValToMax {} {} {Set the current scale value to the maximal scale value.} {
    set $THIS->xMax [set $THIS->xVal]
    .$THIS.max.e delete 0 end
    .$THIS.max.e insert 0 [set $THIS->xVal]
    $THIS -setScale
}

Tcl_Method IOM_EScale -setValToMin {} {} {Set the current scale value to the minimal scale value.} {
    set $THIS->xMin [set $THIS->xVal]
    .$THIS.min.e delete 0 end
    .$THIS.min.e insert 0 [set $THIS->xVal]
    $THIS -setScale
}

Tcl_Method IOM_EScale -max Value Double {Set the max value of the scale to the {ARG 1 Value}.} {
    set $THIS->xMax $Value
    .$THIS.max.e delete 0 end
    .$THIS.max.e insert 0 $Value
}

Tcl_Method IOM_EScale -min Value Double {Set the min value of the scale to the {ARG 1 Value}.} {
    set $THIS->xMin $Value
    .$THIS.min.e delete 0 end
    .$THIS.min.e insert 0 $Value
}

Tcl_Method IOM_EScale -setBorder {Min Max} {Double Double} {Set border values of the scale object to {ARG 1 Min} and {ARG 2 Max} } {
    # set the values of the variables
    set $THIS->xBorderMin $Min
    set $THIS->xBorderMax $Max
    set $THIS->xMin $Min
    set $THIS->xMax $Max

    # update the button labels
    .$THIS.bMax configure -text $Max 
    .$THIS.bMin configure -text $Min 

    # update the entrys
    .$THIS.max.e delete 0 end
    .$THIS.max.e insert 0 $Max 
    .$THIS.min.e delete 0 end
    .$THIS.min.e insert 0 $Min 
}

Tcl_Method IOM_EScale -setCommand {Cmd} {String} {Set an tcl command to the scale widget to send the value of the scale to an other object} {
    set $THIS->xSetCommand $Cmd
}

Tcl_Method IOM_EScale -getCommand {Cmd} {String} {Set an tcl command to the scale widget to get the value of the scale from an other object} {
    set $THIS->xGetCommand $Cmd
}

Tcl_Method IOM_EScale -rescan {} {} {Use the getCommand of the scale object to rescan the new value of the scale} {
    if [string length [set cmd [set $THIS->xGetCommand]]] {
	# rescan the value:
	set val [eval $cmd]
	# check the value:
	if $val>[set $THIS->xBorderMax] {error "Error the value is bigger the the border values! value: $val and border: [set $THIS->xBorderMax]"; return }
	
	# set the member:
	set $THIS->xVal $val
	# set max or min
	if $val>[set $THIS->xMax] {
	    $THIS -max $val 
	} 
	if $val<[set $THIS->xMin] {
	    $THIS -min $val 
	} 
	# update the scale
	$THIS -setScale
    }
}

Tcl_Method IOM_EScale -update {} {} {Use the setCommand of the scale object to set the value of the scale to an othe object.} {
    if [string length [set cmd [set $THIS->xSetCommand]]] {
	eval $cmd [set $THIS->xVal]
    }
}

Tcl_Method IOM_EScale -bitmap {Bitmap} {String} {Set  the bitmap of the scale label to {ARG 1 Bitmap}.} {
    .$THIS.l configure -bitmap $Bitmap
}

IOM_EScale -description {An enhanched scale widget with a bitmap and entrywidgets for the value and the start and end values.} 

IOM_EScale -keywords {IOM Userinterface}