################################################################################
##  Utility functions to generate Tk pixmaps.                                 ##  
##  LAST EDIT: Thu Sep 22 18:35:21 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

proc FramedPixmap {path name {x 200} {y 200}} {

    # define the global variable for the class FramedPixmap
    global FramedPixmap

    frame $path.$name -border 5
    pack append $path $path.$name {left fill expand}
    frame $path.$name.f 
    pack append $path.$name $path.$name.f {top fill expand}
    frame $path.$name.f.f -border 1  -relief  sunken
    
    pack append $path.$name.f $path.$name.f.f {left fill expand}
    PixmapDisplay $path.$name.f.f.px 300 300 
    pack append $path.$name.f.f $path.$name.f.f.px {fill expand}
    
    # define some cursor bindingings for the frame under the pixmap
    catch "$path.$name.f.f configure -cursor tcross"
    bind $path.$name.f.f.px <ButtonPress-2>  "catch \"$path.$name.f.f configure -cursor exchange\""
    bind $path.$name.f.f.px <Shift-ButtonPress-2>  "catch \"$path.$name.f.f configure -cursor box_spiral\""
    bind  $path.$name.f.f.px <ButtonRelease-2>  "catch \"$path.$name.f.f configure -cursor tcross\""
    bind  $path.$name.f.f.px <Shift-ButtonRelease-2>  "catch \"$path.$name.f.f configure -cursor tcross\""
    bind $path.$name.f.f.px <ButtonPress-3>  "catch \"$path.$name.f.f configure -cursor fleur\""
    bind $path.$name.f.f.px <Shift-ButtonPress-3>  "catch \"$path.$name.f.f configure -cursor double_arrow\""
    bind  $path.$name.f.f.px <ButtonRelease-3>  "catch \"$path.$name.f.f configure -cursor tcross\""
    bind  $path.$name.f.f.px <Shift-ButtonRelease-3>  "catch \"$path.$name.f.f configure -cursor tcross\""
    
    bind $path.$name.f.f.px <Shift-ButtonPress-1>  "catch \"$path.$name.f.f configure -cursor sizing\""
    bind  $path.$name.f.f.px <Shift-ButtonRelease-1>  "catch \"$path.$name.f.f configure -cursor tcross\""
    
    set FramedPixmap($path.$name,Tk_Pixmap) $path.$name.f.f.px

    return $path.$name
}


proc PixmapDesktopEvent {pixmap event args} {
    if [string length [info commands $pixmap.DesktopEventHandler]] {
	$pixmap.DesktopEventHandler $pixmap $event $args
    }
}

proc MakePixmapDesktop {name update_proc} {
    # define the global variable for the class FramedPixmap
    global FramedPixmap

    frame $name.top 
    frame $name.bottom  
    frame $name.f.left 
    frame $name.f.right  

    pack before $name.f.f   $name.f.left {filly left} 
    pack append $name.f   $name.f.right {filly right}
    pack append $name   $name.bottom { fillx top}
    pack before $name.f   $name.top {fillx top}
    
    set left    $name.f.left 
    set right   $name.f.right
    set top     $name.top
    set bottom  $name.bottom
    
    global IOM_DIR

    scale $left.sc1 -showvalue 0 -width 10
    scale $left.sc2 -showvalue 0 -width 10
    scale $right.sc  -showvalue 0 -width 10
    label $top.l1 -width 3 
    scale $top.sc -orient horizontal -showvalue 0  -width 10
    label $top.l2 -bitmap @$IOM_DIR/bitmaps/Translation.xbm
    frame $bottom.f 
    label $bottom.f.l1 -bitmap @$IOM_DIR/bitmaps/Rotation.xbm
    frame $bottom.f.sc
    scale $bottom.f.sc.s1 -orient horizontal -showvalue 0 -width 10
    scale $bottom.f.sc.s2 -orient horizontal -showvalue 0 -width 10
    label $bottom.f.l2 -width 1
    frame $bottom.util
    frame $bottom.util.sc

    pack append $bottom \
	    $bottom.f {fill expand}\
	    $bottom.util {fill expand}

    pack append $bottom.f.sc \
	    $bottom.f.sc.s1 { fillx top} \
	    $bottom.f.sc.s2 { fillx top} 

    pack append $bottom.util \
	    $bottom.util.sc { fillx top} 

    pack append $left \
	    $left.sc1 {expand left filly } \
	    $left.sc2 {expand left filly }
    pack append $right $right.sc {expand left filly }
    
    pack append $top \
	    $top.l1 {left} \
	    $top.sc {expand left fillx } \
	    $top.l2 {left}
    
    pack append $bottom.f \
	    $bottom.f.l1 {left} \
	    $bottom.f.sc {expand left fillx } \
	    $bottom.f.l2 {left}

    # Define an array with the pathnames of the event widgets

    set FramedPixmap($name,Scale,Left1,Path)   $left.sc1
    set FramedPixmap($name,Scale,Left2,Path)   $left.sc2
    set FramedPixmap($name,Scale,Top,Path)     $top.sc
    set FramedPixmap($name,Scale,Right,Path)   $right.sc
    set FramedPixmap($name,Scale,Bottom1,Path) $bottom.f.sc.s1
    set FramedPixmap($name,Scale,Bottom2,Path) $bottom.f.sc.s2
    

    # Define the variable of the events from this pixmap

    set FramedPixmap($name,Scale,Events) {Left1 Left2 Top Right Bottom1 Bottom2 }

    # configure the scales to with values from -1000 to 1000

    foreach s $FramedPixmap($name,Scale,Events) { 
	$FramedPixmap($name,Scale,$s,Path) configure \
		-from -1000 \
		-to 1000 \
		-command "PixmapDesktopEvent  $name Scale,$s " 
	$FramedPixmap($name,Scale,$s,Path) set 0
    }
    
    #bind $FramedPixmap($name,Tk_Pixmap) <Button-3> "RemovePixmapDesktop $name $update_proc"
}

proc RemovePixmapDesktop {name update_proc} {
    # define the global variable for the class FramedPixmap
    global FramedPixmap

    destroy $name.f.left
    destroy $name.f.right
    destroy $name.top
    destroy $name.bottom
    bind $FramedPixmap($name,Tk_Pixmap) <Shift-Button-3> "MakePixmapDesktop $name $update_proc"
    $update_proc
}

proc BindPixmap {name update_proc } {
    # define the global variable for the class FramedPixmap
    global FramedPixmap
    set pixmap_path $FramedPixmap($name,Tk_Pixmap)

    #bind $pixmap_path <Metha-Button-3> "MakePixmapDesktop $name $update_proc"
    MakePixmapDesktop $name $update_proc
}

