#ifndef __ATTRIBUTE_OBJECT_H__
#define __ATTRIBUTE_OBJECT_H__

////////////////////////////////////////////////////////////////////////////////
// Access to default attributes                                               //  
// LAST EDIT: Fri Aug  5 08:55:11 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "predattr.h"

extern const char *RTN_ATTRIBUTE_OBJECT;

class RT_AttributeObject: public RT_ResolutionAttrImpl, 
public RT_SurfaceAttrImpl, public RT_FillstyleAttrImpl {

    // this class provides access to attributes
    // the methods can be overloaded to implement
    // user specific attributes

  public:
    static void print(FILE*);

    const RT_Attribute *getDefault(const char *CLASS ) const;
    // get the default attribute of the specified CLASS

    virtual RT_Attribute *create(const char *CLASS, const char *VALUE ) const;
    // create one attribute of the the specified CLASS
    // setup the attribute VALUE from ASCII representation

    virtual int parse( char *ARGV[], RT_Primitive *PRIM );
    // parse attribute set&get from ARGV and apply these to PRIM

    static int attributeCMD(ClientData, Tcl_Interp *, int, char *[]);
    // Tcl interface (default)

    virtual int objectCMD(char *[]) { return 0; }
    // extendend attribute commands

    //#### interface of SOLUTION-attribute:
    void resolution(double s) { 
	RT_ResolutionAttribute::Default.resolution( s );
	RT_ResolutionAttribute::Default.reset();
    }
    double get_resolution() const { 
	return RT_ResolutionAttribute::Default.get_resolution(); }

    //#### interface of SURFACE-attribute:
    void surface(const RT_Surface &_surf) {
	RT_SurfaceAttribute::Default.surface( _surf ); 
	RT_SurfaceAttribute::Default.reset();
    }
    const RT_Surface &get_surface() const { 
	return RT_SurfaceAttribute::Default.get_surface(); }

    void ambient(const RT_Color &ambi) { 
	RT_SurfaceAttribute::Default.ambient( ambi ); 
	RT_SurfaceAttribute::Default.reset();
    }
    const RT_Color &get_ambient() const { 
	return RT_SurfaceAttribute::Default.get_ambient(); }

    void diffuse(const RT_Color &diff) { 
	RT_SurfaceAttribute::Default.diffuse( diff ); 
	RT_SurfaceAttribute::Default.reset();
    }
    const RT_Color &get_diffuse() const { 
	return RT_SurfaceAttribute::Default.get_diffuse(); }

    void specular(const RT_Color &spec)  { 
	RT_SurfaceAttribute::Default.specular(spec); 
	RT_SurfaceAttribute::Default.reset();
    }
    const RT_Color &get_specular() const { 
	return RT_SurfaceAttribute::Default.get_specular(); }

    void emission(const RT_Color &emmi) { 
	RT_SurfaceAttribute::Default.emission( emmi); 
	RT_SurfaceAttribute::Default.reset();
    }
    const RT_Color &get_emission() const { 
	return RT_SurfaceAttribute::Default.get_emission(); }

    void transmission(const double tran) { 
	RT_SurfaceAttribute::Default.transmission(tran); 
	RT_SurfaceAttribute::Default.reset();
    } 
    double get_transmission() const { 
	return RT_SurfaceAttribute::Default.get_transmission(); }

    void refraction(const double refr)  { 
	RT_SurfaceAttribute::Default.refraction(refr); 
	RT_SurfaceAttribute::Default.reset();
    }
    double get_refraction() const { 
	return RT_SurfaceAttribute::Default.get_refraction(); }

    void shininess(const double shin)  { 
	RT_SurfaceAttribute::Default.shininess(shin); 
	RT_SurfaceAttribute::Default.reset();
    }
    double get_shininess() const { 
	return RT_SurfaceAttribute::Default.get_shininess(); }

    void specfunc(const char *s) {
	RT_SurfaceAttribute::Default.specfunc( s ); 
	RT_SurfaceAttribute::Default.reset();
    }
    const char *get_specfunc() const { 
	return RT_SurfaceAttribute::Default.get_specfunc(); }

    //#### interface of FILLSTYLE-attribute:
    void fillstyle(int s) { 
	RT_FillstyleAttribute::Default.fillstyle(s); 
	RT_FillstyleAttribute::Default.reset();
    }
    int get_fillstyle() const { 
	return RT_FillstyleAttribute::Default.get_fillstyle(); }
};

extern RT_AttributeObject *rt_AttributeObject;

#endif
