////////////////////////////////////////////////////////////////////////////////
//  The color class. Operators, Set&Get, Conversions.                         //  
//  LAST EDIT: Wed Aug 17 09:01:59 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "color.h"
#include "global.h"
#include "utils.h"

RT_Color::operator unsigned long () const {
    unsigned long l = ((long)(255 * r)) +
	((long)(255 * g) << 8) +
	    ((long)(255 * b) << 16);
    return l;
}

RT_Color::RT_Color(unsigned long l) {
    char *c = (char *)&l;
    r = ((float)c[3])/255.;
    g = ((float)c[2])/255.;
    b = ((float)c[1])/255.;
}

int RT_Color::set(const char *xval) {
    int argc; char **argv;
    if (Tcl_SplitList( rt_Ip, (char*)xval, &argc, &argv) == TCL_OK) {
	int ok = 0;
	double d[3];
	int n = argc < 3 ? argc : 3; 
	for (int i = 0; i < n; i++) {
	    ok = RT_string2double( argv[i], d[i]);
	    if (!ok) break;
	}
	if (ok) { r = d[0]; g = d[1]; b = d[2]; }
	free((char*)argv);
	return ok;
    }
    return 0;
}

int RT_Color::operator==(const RT_Color &s) const {
    if (r != s.r) return 0;
    if (g != s.g) return 0;
    if (b != s.b) return 0;
    return 1;
}

void RT_Color::setHSL(double hsl[3]) {
    double &h = hsl[0];
    double &s = hsl[1];
    double &l = hsl[2];
    double v = (l <= 0.5) ? (l * (1.0 + s)) : (l + s - l * s);
    if (v <= 0) { r = g = b = 0.0; }
    else { 
	double m = l + l - v;
	double sv = (v - m ) / v;
	h *= 6.0;
	int sextant = (int)h;    
	double fract = h - sextant;
	double vsf = v * sv * fract;
	double mid1 = m + vsf;
	double mid2 = v - vsf;
	switch (sextant) {
	  case 0: r = v; g = mid1; b = m; break;
		case 1: r = mid2; g = v; b = m; break;
		case 2: r = m; g = v; b = mid1; break;
		case 3: r = m; g = mid2; b = v; break;
		case 4: r = mid1; g = m; b = v; break;
		case 5: r = v; g = m; b = mid2; break;
	      }
    }
}

#define max3(a,b,c)     (((a)>(b))?((a)>(c)?(a):(c)):(((b)>(c))?(b):(c)))
#define min3(a,b,c)     (((a)<(b))?((a)<(c)?(a):(c)):(((b)<(c))?(b):(c)))

void RT_Color::getHSL(double hsl[3]) const {
    double &h = hsl[0];
    double &s = hsl[1];
    double &l = hsl[2];
    double v = max3(r,g,b);
    double m = min3(r,g,b);
    if ((l = (m + v) / 2.0) <= 0.0) return;
    double vm;
    if ((s = vm = v - m) > 0.0) {
	s /= (l <= 0.5) ? (v + m ) : (2.0 - v - m) ;
    } else return;

    double r2 = (v - r) / vm;
    double g2 = (v - g) / vm;
    double b2 = (v - b) / vm;

    if (r == v) h = (g == m ? 5.0 + b2 : 1.0 - g2);
    else if (g == v) h = (b == m ? 1.0 + r2 : 3.0 - b2);
    else h = (r == m ? 3.0 + g2 : 5.0 - r2);
    h /= 6;
}


