#ifndef __GLOBAL_H__
#define __GLOBAL_H__

////////////////////////////////////////////////////////////////////////////////
//  Global declarations and functions important for the whole system.         //  
//  LAST EDIT: Fri Aug  5 08:55:20 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <tcl.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

#ifndef NULL
#define NULL 0
#endif
 
#include "strings.h"
#include "macros.h"

extern double rt_UndefinedBounds;

// the global epsilon:
extern double rt_RayEps;

extern double rt_MaxDistance;

// the maximum level of recursion:
extern int rt_MaxLevel; 

extern double rt_MinWeight;

// the global Tcl interpreter:
extern Tcl_Interp *rt_Ip;

// the global hash table containing 
// all C++/Tcl objects:
extern Tcl_HashTable rt_Hash;

// list of the packages:
extern RT_String rt_PackageList; 

// list of the built-in primitive classes including package classes, too:
extern RT_String rt_PrimitiveClassList; 

class RT_GlobalList;
// the list of all Tcl/C++ objects:
extern RT_GlobalList *rt_Objects;
class RT_Output;
extern RT_Output *rt_Output;

class RT_Surface;
// the global reference "NULL surface":
extern const RT_Surface RT_NULL_SURFACE;

class RT_Vector;
// the global reference "NULL normal": 
extern const RT_Vector RT_NULL_NORMAL;

// the global reference for an invalid normal:
extern const RT_Vector RT_BAD_VECTOR; 
// return this vector in case of access errors

class RT_Matrix;
extern const RT_Matrix RT_IDENTITY;

// list of all default attributes:
class RT_GeneralList;
extern RT_GeneralList rt_DefaultAttributes;
extern const RT_GeneralList RT_NULL_LIST;

// global and Tcl-accessible variables:

extern int rt_RayDebug; 
// if equal 1 - print intersect points when ray-tracing

extern int rt_PickDebug; 
// if equal 1 - print intersect points when picking

extern int rt_RefractedShadows; 
// if equal 1 compute refracted shadows

extern RT_String rt_YARTProgram; 
// the binary that should execute the saved YART code

#endif

