////////////////////////////////////////////////////////////////////////////////
//  font implementation                                                       //  
//  LAST EDIT: Thu Nov 17 13:31:19 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <limits.h>
#include "font.h"
#include "error.h"
#include "defines.h"


const char *RTN_FONT = "Font";

RT_Font *rt_DefaultFont = 0;

RT_FontData::RT_FontData(short n, signed char *buf) {
    ppline = 0; px = py = 0; lines = 0; l_off = r_off = 0;
    if (n < 2 || !buf) return;
    l_off = R_relativ(buf[0]); r_off = R_relativ(buf[1]);
    if (n < 6) return;
    for(int t = 6; t < n; t+= 2)
	if (buf[t] == ' ') lines++;
    if (buf[t-2] != ' ') lines++;
    ppline = new short [lines];
    px = new signed char* [lines];
    py = new signed char* [lines];
    for(t=0;t<lines;t++) {ppline[t]=0; px[t] = py[t] = 0;}
    int p = 2;
    for (t = 0; t < lines; t++) {	    
	for (int tt = p+4; tt < n && buf[tt] != ' '; tt+=2);
	ppline[t] = (tt - p) / 2;
	px[t] = new signed char[ppline[t]];
	py[t] = new signed char[ppline[t]];
	for (int ttt = p; ttt < tt; ttt+=2) {
	    px[t][(ttt-p)/2] = R_relativ(buf[ttt]) - l_off;
	    py[t][(ttt-p)/2] = -R_relativ(buf[ttt+1]); // there tv coords
	}
	p = tt+2;
    }
}

#if BYTE_ORDER == BIG_ENDIAN 
#define ntohs(x)        (x)
#else
#if BYTE_ORDER == LITTLE_ENDIAN 
static unsigned short ntohs(unsigned short x) { return (x << 8) | (x >> 8); }
#endif
#endif

RT_Font::RT_Font( char *_name, FILE *fFile ): fName( _name) {
    unsigned short d;
    int t;
    maxPoints = maxLines = baseLineDist = capHeight = 0;
    for(t = 0; t<MAX_CHARS; t++) fData[t] = 0;
    fread( &d, sizeof(short),1,fFile); nchars = ntohs(d);
    // not needed:
    fread( &d, sizeof(short), 1, fFile); // number of vectors in font
    fread( &d, sizeof(short), 1, fFile); // max ascender
    fread( &d, sizeof(short), 1, fFile); // max descender
    fread( &d, sizeof(short), 1, fFile); // max width
    int bufsize = 100;
    signed char *buf = new signed char[bufsize];
    for(t = HERSH_FIRST_CHAR; t < nchars + HERSH_FIRST_CHAR && t < MAX_CHARS; t++) {
	fread(&d,sizeof(short),1,fFile); d = ntohs(d);
	if (d > bufsize) {bufsize = d;delete [] buf; buf=new signed char[bufsize];}
	fread(buf,sizeof(char),d,fFile);
	fData[t] = new RT_FontData(d,buf);
	// set maxLines and maxPoints
	int lines = fData[t]->get_lines();
	if (lines > maxLines) maxLines = lines;
	for(int l=0; l<lines;l++) {
	    int p = fData[t]->get_numberOfPoints(l);
	    if (p > maxPoints) maxPoints = p;
	}	    
    }
    delete buf;
    // set baseLineDist and capHeight:
    t = 'A';
    if (!fData[t])
	for(t = HERSH_FIRST_CHAR + 1; t < nchars + HERSH_FIRST_CHAR && t < MAX_CHARS && !fData[t]; t++);
    if (fData[t]) {
	baseLineDist = SCHAR_MAX; capHeight = SCHAR_MIN;
	for (int tt = 0; tt < fData[t]->get_lines(); tt++) {
	    for (int ttt = 0; ttt < fData[t]->get_numberOfPoints(tt); ttt++) {
		RT_Vector v = fData[t]->get_point(tt,ttt);
		if ((int)v.y < baseLineDist) baseLineDist = (int)v.y;
		if ((int)v.y > capHeight) capHeight = (int)v.y;
	    }
	}
	capHeight -= baseLineDist;
    }
}

RT_Font *RT_FontServer::getFont(char *fname) {
    // first check for default font:
    if (!strcmp( fname, RTD_DEFAULT_FONT )) {
	if (!rt_DefaultFont) {
	    // try loading default font:
	    RT_String defaultFont( 200 );
	    defaultFont = getenv( RT_GOOD_ROOT_DIR );
	    defaultFont += RTD_FONT_PATH;
	    defaultFont += RTD_DEFAULT_FONT; 
	    FILE *fFile = fopen( (char*)defaultFont, "r" );
	    if (!fFile) { 
		rt_Output->fatal( "Couldn't find the default font!" );
		return 0;
	    }
	    append( rt_DefaultFont = new RT_Font( fname, fFile ) );
	    fclose(fFile);
	}
	return rt_DefaultFont;
    }
    
    // look for an another font:
    RT_GeneralListElem *tmp = root;
    if (tmp) do if (!strcmp((char*)((RT_Font*)tmp->elem)->getName(), fname )) return (RT_Font*)tmp->elem;
    while(tmp = tmp->next);

    // attemp to load the font:
    RT_String path( 200 );
    path = getenv( RT_GOOD_ROOT_DIR );
    path += RTD_FONT_PATH;
    path += fname;
    FILE *fFile = fopen( (char*)path, "r" );
    if (!fFile) {
	rt_Output->warningVar( "Couldn't find font ", (char*)path, ", using default font!", 0 );
	return getFont( RTD_DEFAULT_FONT );
    }
    RT_Font *f;
    append( f = new RT_Font( fname, fFile ) );
    fclose(fFile);
    return f;
} 
