////////////////////////////////////////////////////////////////////////////////
//  definition of a generic matrix class                                      //  
//  LAST EDIT: Fri Feb 10 15:40:21 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __GENMATRIX_H__
#define __GENMATRIX_H__

#include "genvector.h"

class _Matrix {
    _Vector** v;
    int  rows;
    int  cols;

    void flip_rows(int,int);
    void check_dimensions(const _Matrix&) const; 
    double& elem(int, int) const;
    double** triang(const _Matrix&, int&) const;
  public:
    _Matrix(int n=0, int m=0);
    _Matrix(const _Matrix&);
    _Matrix(const _Vector&);
    _Matrix(int,int,double**);
    
    _Matrix& operator=(const _Matrix&);
  
    ~_Matrix();

    int Rows() const {  return rows; }
    int Cols() const {  return cols; }
    
    void newGeometry(int,int);
  
    _Vector& row(int i) const;
    _Vector col(int i) const;

    _Matrix  trans() const;
    _Matrix  inv()   const;
    double  det()   const;

    _Matrix solve(const _Matrix&) const;
    _Vector solve(const _Vector& b) const { return _Vector(solve(_Matrix(b))); }
    
    operator _Vector() const; 
  
    _Vector& operator[](int i) const { return row(i); }
  
    double& operator()(int i, int j);
    double  operator()(int,int) const;
    
    int operator==(const _Matrix&)    const;
    int operator!=(const _Matrix& x)  const { return !(*this == x); }
  
    _Matrix operator+(const _Matrix& M1);
    _Matrix operator-(const _Matrix& M1);
    _Matrix operator-(); // unary
  
    _Matrix& operator-=(const _Matrix&);
    _Matrix& operator+=(const _Matrix&);
  
    _Matrix operator*(const _Matrix& M1);
  
    _Vector operator*(const _Vector& vec) { return _Vector(*this * _Matrix(vec)); }
    _Matrix operator*(double x);

    void print( FILE*) const;
};

#endif





