////////////////////////////////////////////////////////////////////////////////
//  Implementation of OBA primitive.                                          //  
//  LAST EDIT: Fri Aug  5 08:55:03 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "oba.h"
#include "usefprim.h"
#include "../intset.h"

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <math.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

const char *RTN_OBA_PRIMITIVE = "OBAPrimitive";

typedef struct { 
    int obj;
    int vertex_number;
    int vertex[4];
} rt_OBAPolyData;

typedef struct {
    float f[3];
} rt_OBAFloat3;
                   
RT_OBAPrimitive::RT_OBAPrimitive(char *a, char *_file): RT_Primitive( a ) {
    file = new char[ strlen( _file)+ 1];
    strcpy( file, _file );

    // open the data files for reading:
    RT_String str(40);
    str = file; str += ".oba";
    FILE *oba = fopen( str, "r" );
    if (!oba) {
	rt_Output->errorVar( get_name(), ": No OBA file ", (char*)str, "!", 0 ); 
	return;
    }
    
    str = file; str += ".hla";
    FILE *hla = fopen( str, "r" );
    
    // read the number of vertices:
    int number_of_surfaces,number_of_vertexes,number_of_hla_vertexes; 
    fscanf( oba, "%i %i", &number_of_surfaces, &number_of_vertexes); 
    if(hla) {
	fscanf( hla, "%i", &number_of_hla_vertexes);
	if(number_of_vertexes != number_of_hla_vertexes) 
	    rt_Output->warning("OBAPrimitive: number of vertices is not equal the number of hla datas.");
    }

    // alloc memory to hold the datas:
    rt_Output->message("OBA reading: Allocate memory from system.");
    rt_OBAPolyData *polyList = new rt_OBAPolyData[number_of_surfaces];
    rt_OBAFloat3 *vertexList = new rt_OBAFloat3[number_of_vertexes];
  
    float *hlaData = NULL;
    if (hla) hlaData = new float[number_of_hla_vertexes];
    rt_Output->message("OBA reading: Allocate memory - ready");
    
    // make a set to hold the object numbers in the oba file
    RT_IntSet objNumbers(32);

    rt_Output->message("OBA reading: Read the polygons.");

    // read the polygons
    int code,n_vertex,vt,obj_num;
    for (int i = 0; i <number_of_surfaces ; i++ ) {
	fscanf( oba, "%i", &code);
	// set the number of vertex defined in the last digit
	n_vertex = code % 10;
	polyList[i].vertex_number = n_vertex;
	// set the object number
	obj_num = code / 10;
	polyList[i].obj = obj_num;
	objNumbers.setId(obj_num);

	// read the vertexes
	for (vt = 0; vt < n_vertex; vt++)
	    fscanf( oba, "%i", &polyList[i].vertex[vt] );
    }

    rt_Output->message("OBA reading: Read the vertices.");
    // read the vertex
    for (i = 0; i <number_of_vertexes ; i++ ) {
	fscanf( oba, "%f %f %f", &vertexList[i].f[0],
		&vertexList[i].f[1],&vertexList[i].f[2]);
    }
    float max,min;
    int first = 1;
    // read the hla datas:
    if (hla) 
	rt_Output->message("OBA reading: Read the data.");

	for (i = 0; i <number_of_hla_vertexes ; i++ ) {
	    float val,f,sumquad=0;
	    for (int j=0;j<6;j++) {
		fscanf( hla, "%f", &f);
		sumquad += f*f;}
	    val = sqrt(sumquad);
	    hlaData[i] = val;
	    if(first) {min = val;max = val;first = 0;}
	    if(min>val) min = val;
	    if(max<val) max = val;
	    printf("val: %f; min: %f; max: %f\n",val,min,max);
	}
    
    // create the polygons:
    RT_Vector points[4];
    RT_Surface surface[4];
    
    // reset the set with the object numbers:
    objNumbers.firstId();
    int objNumber;

    // double for each object:
    while ((objNumber=objNumbers.getNextId()) != -1) {
	char str[20];
	sprintf(str," Object %d ",objNumber);
	rt_Output->messageVar("OBA read:",str,0);

	sprintf(str,"%s.p%d",a,objNumber);
	RT_Top *ps = new RT_Top(str);
	//ps->ignorePartModelling=1;
	for (i = 0; i < number_of_surfaces; i++ ) {
	    // get the coordinates of the vertexes
	    for(int j = 0; j<polyList[i].vertex_number; j++) {
		// get the number of the vertex
		int vertex_num = polyList[i].vertex[j]-1;
		RT_Vector point (vertexList[vertex_num].f[0],
				 vertexList[vertex_num].f[1],
				 vertexList[vertex_num].f[2]);
		points[j] = point;
		
		// if hlaData`s then set the emission to the 
		// value of the hla`s:
		if (hla) {
		    // test the number of vertex and the max
		    // number of hla data:
		    if (vertex_num<number_of_hla_vertexes) {
			// normalize the values to 0-1:
			float val = (hlaData[vertex_num]-min)/(max-min);
		    }
		}
	    }
	    // build the polygon: 
	    RT_Polygon *p;
	    
            // if surface propertys then set the diffuse reflection:
	    p = new RT_Polygon( 0,polyList[i].vertex_number,points, hla ? surface: 0 );

	    // calculate the normal:
	    RT_Vector norm;
	    RT_calcNorm(polyList[i].vertex_number,points,norm);
	    p->gnormal(norm);
	}
	ps->father(this);
    }
    delete polyList;
    delete vertexList;
    fclose( oba );
    if(hla) {
	fclose( hla );
	delete hlaData;
    }
    rt_Output->message("OBA reading: Ready!");
}

int RT_OBAPrimitive::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {STRING FILE} {Creates polygon set's from OBA files, parameters: {ARG 1 Name}, {ARG 2 File} without extension.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 3 ) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <file>. ", NULL );
	    return TCL_ERROR;
	}
	new RT_OBAPrimitive( argv[1], argv[2] ); 
	RTM_classReturn;
    }
    return res; 
}


