////////////////////////////////////////////////////////////////////////////////
//  Definition of the OFF format file reader for OFFPolyhdron                 //  
//  LAST EDIT: Wed Mar  8 14:32:48 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __OFFPOLYHEDRON_H__
#define __OFFPOLYHEDRON_H__

#include "aoff.h"
#include "primitiv.h"
#include "vertex.h"
#include "facet.h"
#include <limits.h>

extern const char *RTN_OFF_POLYHEDRON;

class RT_OFFPolyhedron: public RT_Polyhedron {
    //##### private data:
    int readObj(char *);
    struct OFFProp AOFFProp; // property header for AOFF files
  public:

    //##### Tcl/C++ methods:
    RT_OFFPolyhedron( char *, char *);
    const char *get_class() const { return RTN_OFF_POLYHEDRON; }
    int isA(const char *_c) const { return RT_Polyhedron::isA( _c ) || 
					RTM_isA(_c, RTN_OFF_POLYHEDRON ); }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

#endif
