#ifndef __RECORDER_H__
#define __RECORDER_H__

////////////////////////////////////////////////////////////////////////////////
//  Class for recording animations using image recording.                     //  
//  LAST EDIT: Fri Aug  5 08:54:58 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../image.h"
#include "../camera.h"

#define RTN_RECORDER "Recorder"

class RT_Recorder:public RT_Object {
    static RT_ParseEntry table[];
  protected:
    //#### the statics for parameter parsing:
    static int stF, nxF, cmG, cmF;
    static char *cmV;
  protected:
    int no; // keyframe no. (from zero)
    RT_Camera *xcam; // the related camera
    void objectKilled(RT_Object *a) {
	if (a == xcam) camera( (RT_Camera*)-1 );
	RT_Object::objectKilled( a );
    }
  public:
    //#### the Tcl/C++ methods: 
    RT_Recorder(char *name): RT_Object(name) { no = 0; xcam = 0; }

    int isA(const char *_c) const { return RTM_isA(_c, RTN_RECORDER ) || RT_Object::isA( _c ); }

    virtual void start() {
	// (re)start the animation
	no = 0;
	next();
    }

    virtual void next() {
	// next keyframe
	if (xcam) xcam->rendering();
	no++;
    }

    void camera(RT_Camera *); 
    RT_Camera *get_camera() const { return xcam; }

    virtual void print(FILE *f) const { 
	RT_Object::print( f );
	if (get_camera()) fprintf( f, "%s -camera %s\n", 
				  get_name(), get_camera()->get_name()); 
    }
    //#### the Tcl commands:
    int objectCMD(char *[]);
};

extern const char *RTN_IMAGE_RECORDER;

class RT_ImageRecorder:public RT_Recorder {
    static RT_ParseEntry table[];
  protected:
    //#### the statics for parameter parsing:
    static int imG, imF;
    static char *imV;
    RT_String fname; // file name template
    RT_Image *ximage;
    virtual void objectKilled(RT_Object *a) {
	if (a == ximage) image( (RT_Image*)-1 );
	RT_Recorder::objectKilled( a ); 
    }
  public:
    //#### the Tcl/C++ methods:
    RT_ImageRecorder(char *name, char *_fname): RT_Recorder(name), fname( _fname) {
	ximage = 0;    
    }
    virtual ~RT_ImageRecorder() {}

    const char *get_class() const { return RTN_IMAGE_RECORDER; }
    const char *get_description() const { return "Objects of this class can be used for recording of animations by rendering them into images."; }
    int isA(const char *_c) const { return RTM_isA(_c, RTN_IMAGE_RECORDER ) || RT_Recorder::isA( _c ); }

    void image(RT_Image *);
    RT_Image *get_image() const { return ximage; }

    virtual void next();

    void printCon(FILE *f) const { 
	RT_Object::printCon( f );
	fprintf( f, " %s ", (char*)fname ); 
    }
    void print(FILE *f) const { 
	RT_Object::print( f );
	if (get_camera() || get_image()) {
	    fprintf( f, "%s ", get_name());
	    if (get_camera()) fprintf( f, "-camera %s ", get_camera()->get_name()); 
	    if (get_image()) fprintf( f, "-image %s ", get_image()->get_name()); 
	    fprintf( f, "\n" );
	}
    }
    //#### the Tcl comands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

#endif

