////////////////////////////////////////////////////////////////////////////////
//  implementation of rotation surface                                        //  
//  LAST EDIT: Wed Mar  8 13:43:06 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#include "rotforms.h"

const char *RTN_ROTATION_SURFACE = "RotationSurface";

int RT_RotationSurface::getOrdF, RT_RotationSurface::modeF, RT_RotationSurface::modeV;
int RT_RotationSurface::getModeF;

int RT_RotationSurface::classCMD( ClientData cd, Tcl_Interp *ip, int argc, char *argv[] ) {
    int res = _classCMD( cd, ip, argc, argv );
    if (res == TCL_HELP) {
        Tcl_AppendResult( ip, "{", argv[0], " { String Integer Vector_List Surface_List Vector_List} {  Creates a new surface of revolution with a b-spline curve of given parameters as base. {ARG 1 Name} of the new object, {ARG 2 Number} of initial elements, list of {ARG 3 Points}, list of {ARG 4 Surfaces}, list of {ARG 5 Normals}. The surface and normals list can be empty.}}", 0 );
	return TCL_OK;
    }
    if (res == TCL_OK) { 
	int ret = TCL_ERROR; int nr;
	RT_Vector  *vecs; RT_Surface *surfs; RT_Vector *norms;
	if ( createPoly( ip, argc, argv, nr, vecs, surfs, norms) == TCL_OK ) {
	    new RT_RotationSurface( argv[1], nr, vecs, surfs, norms );
	    RTM_classReturn;
	}
	else rt_Output->errorVar( argv[0], ": Could not create a base curve!", 0);
	if (vecs) delete [] vecs; if (surfs) delete [] surfs; if (norms) delete [] norms;
	return ret;
    }
    return res;
}

void RT_RotationSurface::createReferences(const RT_AttributeList &list) {
    RT_Polyvertex::createReferences( list );
    // create resolution reference:
    RT_ResolutionAttribute *tmp = xsolution;
    xsolution = (RT_ResolutionAttribute*)list.retraverse( RTN_RESOLUTION_ATTR, this );
    if ( (tmp != xsolution) || (*tmp != *xsolution)) geomChanged();
}

void RT_RotationSurface::resolution(double s) { 
    xsolution = (RT_ResolutionAttribute*)attributes->get( RTN_RESOLUTION_ATTR );
    if (!xsolution) 
	attributes->insert( xsolution = new RT_ResolutionAttribute);
    xsolution->resolution( s );
    geomChanged();
}
RT_ParseEntry RT_RotationSurface::table[] = {
    {"-order",  RTP_SPECIAL, 0, 0, "Change the order of the rotated surface in {ARG 1 Horizontal} and {ARG 2 Vertical} direction. The second value is quasi the order of rotating curve.", "Integer Integer" },
    { "-get_order", RTP_NONE, 0, &getOrdF, "Get current order of the surface in horizontal and vertical direction {ARG 2} ", RTPS_NONE },
    { "-mode",  RTP_INTEGER, (char*)&modeV, &modeF, "set the {ARG 1 Mode} 0 - an opened or 1 - closed curve will be rotated around the y-axis", RTPS_INTEGER },
    { "-get_mode", RTP_NONE, 0, &getModeF, "Get current mode of the surface",  RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_RotationSurface::objectCMD( char *argv[] ) {
    int ret = RT_Polyvertex::objectCMD( argv );
    RT_parseTable( argv, table );
    {
	int start, diff1 = 0, diff2 = 0;
	int ordU, ordW;
	if ((start = RT_findString( argv, "-order" )) >= 0) {
	    if ( RT_getInt( &argv[ start + 1 ], ordU, diff1) ) {
		if ( RT_getInt( &argv[ start + 2 ], ordW, diff2) ) {
		    xssurface->setOrder(ordU,ordW);
		    ret++;
		}
	    }
	}
	RT_clearArgv( argv, start, diff1 + diff2 );
    }
    if (getOrdF) {
	static char tmp1[3]; static char tmp2[3]; static char tmp[8]; ret++;
	RT_int2string( xssurface->getOrdU(),tmp1 );
	RT_int2string( xssurface->getOrdW(),tmp2 );
	sprintf( tmp,"%s %s",tmp1,tmp2 );
	RT_Object::result( tmp );
    }
    if (modeF) {
	xssurface->setSurfMod( (RT_SurfaceMode)modeV );
	ret++;
    }
    if (getModeF) {
	static char tmp[5]; ret++;
	RT_int2string( xssurface->getSurfMod(), tmp );
	RT_Object::result( tmp );
    }
    
    return ret;
}

RT_RotationSurface::RT_RotationSurface( char *a, int b, RT_Vector *c, RT_Surface *d, RT_Vector *e ) : 
RT_Polyvertex( a, b, c, d, e) {
    xssurface = new RT_SplineSurface;
    xssurface->setSurfMod(RTE_CLOSED_HORIZONTAL);
    xssurface->father(this);
}

int RT_RotationSurface::copy( RT_Primitive *v ) const {
    if (v->isA( RTN_SPLINE_SURFACE )) {
	RT_SplineSurface *s = (RT_SplineSurface*)v;
	s->newGeometry( xssurface->get_x(), xssurface->get_y() );
	s->setOrder( xssurface->getOrdU(), xssurface->getOrdW() );
	s->setSurfMod( (RT_SurfaceMode)xssurface->getSurfMod() );
	
	for ( int i = 0; i < xssurface->get_y(); i++ ) {
	    for ( int j = 0; j < xssurface->get_x(); j++ ) {
		s->vtPoint( j,i, xssurface->get_vtPoint(j,i) );
		s->vtSurface( j,i, xssurface->get_vtSurface(j,i) );
		s->vtNormal( j,i, xssurface->get_vtNormal(j,i) );
	    }
	}  
	return(1);
    }
    if (v->isA( RTN_QUADMESH )) return(xssurface->copy( v ));
    if (v->isA( RTN_POLYVERTEX)) return( RT_Polyvertex::copy( v ) ); 
    return( RT_Primitive::copy( v ));
}

void RT_RotationSurface::create() {
    // dimensions of the base Quadmesh:
    int rotDimX, rotDimY; 
    int nr = get_number();
    
    // compute and set the dimensions:
    rotDimX = (int)( 16*get_resolution() + 4);
    rotDimY = nr;
    
    // create the new base Quadmesh:
    xssurface->newGeometry( rotDimX, rotDimY );
    // set order of the part-surface:
    xssurface->setOrder( rotDimX >= 3 ? 3 : rotDimX, rotDimY >= 3 ? 3 : rotDimY );
    
    double a;
    double da = (double)( 2*M_PI/rotDimX );
    
    RT_Vector v, tv;
    int j;
    for ( int i = 0; i < rotDimY; i++ ) {
	const RT_Surface &s = get_vtSurface(i);
	tv = v = get_vtPoint(i);
	for ( j = 0, a = da; j < rotDimX; a += da, j++ ) {
	    xssurface->vtPoint( j, i, tv);
	    xssurface->vtSurface(j, i, s);

	    tv.x = v.x * cos(a) + v.z * sin(a);
	    tv.y = v.y;
	    tv.z = v.x * (-sin(a)) + v.z * cos(a);
	} 
    }
}


