#ifndef __TEXT_H__
#define __TEXT_H__

////////////////////////////////////////////////////////////////////////////////
//  A Text implementation basing on Lines and Polygons.                       //  
//  LAST EDIT: Tue Nov 15 15:44:59 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "poly.h"
#include "font.h"

extern RT_FontServer rt_FontServer;
// the global font list we're usin' in YART

// the class TEXT

extern const char *RTN_TEXT;

class RT_Text: public RT_Primitive {
  int maxlines, maxpoints; 
  void create();
  static RT_ParseEntry table[];
  RT_String textstring;
  RT_Vector tpos;
  RT_Polyvertex **pvx;
  RT_Vector *pnt;
  RT_Font *fnt;
  int xAlign, yAlign, zAlign;
  int xAlignInit, yAlignInit, zAlignInit;
  int fontCreated;
  double tHeight, tDepth, tWidth;
  //##### statics for parameter parsing:
  static char *fnV, *txtV;
  static int fnF, fnG, thF, thG, twF, posG, posF;
  static int wG, xalF, xalV, yalV, yalF, txtF, txtG;
  static int tdG, tdF, zalF, zalV, xalG, yalG, zalG;
  static double thV, twV, tdV;
  static RT_Vector posV;
  void deletePoly();
 public:
  //#### the Tcl/C++ methods:
  RT_Text( char *_name, char *_string, RT_Vector _tpos ) : RT_Primitive(_name), textstring( _string) {
      tpos = _tpos;
      pnt = 0; pvx = 0; 
      maxlines = 0; maxpoints = 0;
      xAlign = -1;
      yAlign = -1;
      zAlign = 0;
      xAlignInit = xAlign;
      yAlignInit = yAlign;
      zAlignInit = zAlign;
      tHeight = 1.0;
      tDepth = 0.0;
      tWidth = 0.0;
      
      font( RTD_DEFAULT_FONT );
      fontCreated = 0;
  }

  const char *get_class() const { return RTN_TEXT; }
  int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_TEXT );}
  const char *get_description() const { return "A polyline or polygon based text primitive."; }

  void printCon(FILE *f) const { 
      RT_Primitive::printCon( f );
      fprintf( f, "{%s} ", (char*)textstring ); tpos.print( f );
  }
  void print(FILE *) const;

  void font( char *_newFont);
  char *get_font() const { return fnt ? fnt->getName() : ""; }

  void text( char * );
  char *get_text() const { return textstring; }

  void width( double );
  double get_width() const;

  void height( double );
  double get_height() const { return tHeight; }

  void depth( double );
  double get_depth() const { return tDepth; }

  void pos( RT_Vector p );
  RT_Vector get_pos() { return tpos; }

  void xalign( int );
  int get_xalign() const { return xAlign; }

  int get_yalign() const { return yAlign; }
  void yalign( int );

  void zalign( int );
  int get_zalign() const { return zAlign; }

  //#### the Tcl commands:
  static int classCMD( ClientData, Tcl_Interp *, int, char *[]);
  int objectCMD( char *[]);
};

#endif

  






