#ifndef __IMAGE_H__
#define __IMAGE_H__

////////////////////////////////////////////////////////////////////////////////
// Declaration of class Image - the essential base class for import/export of //
// pixmap files.                                                              //  
//  LAST EDIT: Fri Aug  5 08:55:19 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "object.h"

class RT_Pixmap;

extern const char *RTN_IMAGE;

void rt_initImageCommands( Tcl_Interp *);

class RT_Image: public RT_Object {
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int rdF, wrF, fnF, fnG, clF, clG, wiV, wiF, wiG, hgV, hgF, hgG, icG, extG;
    static int pxF; static char *pxV;
    static char *fnV;
  protected:
    int xsize, ysize;
    RT_String fname;

    // returns 1 if indices are valid:
    int checkIndices(int, int) const;

    virtual void newGeometry() = 0;
    // rearrange place for pixmap data

    unsigned long *base;
    // the pointer to a data array

    int objectCMD(char *[]);
  public:
    // #### Tcl/C++ methods:
    RT_Image(char *_name,char *_fname):RT_Object(_name), fname( _fname ) { 
	xsize = ysize = 0;
	base = 0;
    }
    virtual ~RT_Image() { if (base) delete base; }

    void printCon(FILE *f) const {  RT_Object::printCon( f ); fprintf( f, "%s ", (char*)fname ); }
    void print( FILE *f) const {
	printCon( f );
	fprintf( f, "\n%s -width %i -height %i\n", get_name(), get_width(), get_height() );
    }
    int isA(const char *_c) const { return RT_Object::isA( _c ) || RTM_isA(_c, RTN_IMAGE ); }

    virtual int read() = 0;
    virtual int write() = 0;
    // both routines return 1 if successful

    void readPixmap( RT_Pixmap*);

    void filename(char *f) { fname = f; }
    char *get_filename() const { return (char*)fname; }

    void width(int _x) { xsize = _x; newGeometry(); }
    int get_width() const { return xsize; }

    void height(int _y) { ysize = _y; newGeometry(); }
    int get_height() const { return ysize; }

    virtual void color(int, int, const RT_Color &) = 0;
    virtual RT_Color get_color(int, int) const = 0;
    RT_Color get_icolor(double, double) const;

    virtual const char *get_extension() const = 0;
};

#endif

