////////////////////////////////////////////////////////////////////////////////
// Intersecttion class and -list implemenation.                               //  
//  LAST EDIT: Fri Aug  5 08:55:27 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "intrsect.h"

const char *RTN_INTER_SECTION = "InterSection";

int RT_InterSection::operator < (RT_InterSection &i) {
    return t < i.t; 
}

void RT_InterSectionList::sort() {
    if (nr < 2) return;
    RT_InterSection **all = new RT_InterSection*[nr];
    RT_InterSection **ta = all;
    RT_GeneralListElem *tmp = root;
    do 	*ta++ = (RT_InterSection*)tmp->elem;
    while (tmp = tmp->next);
    RT_InterSection *is, *nx;
    int pos, ipos;
    tmp = root;
    for ( int i = 0; i < nr; i++ ) {
	pos = 0;
	ta = all;
	while (!*ta) { ta++; pos++; }
	// looking for the first valid entry
	is = *ta++;
	ipos = pos++;
	for ( int j = 1; j < (nr - i); j++ ) {
	    while (!*ta) { ta++; pos++; } 
	    nx = *ta++; 
	    // get the next valid
	    if (*nx < *is) {
		is = nx;
		ipos = pos;
	    }
	    pos++;
	}
	all[ipos] = 0;
	tmp->elem = is;
	// write found intersection into list element
	tmp = tmp->next;
    }
    delete all;
}

void RT_InterSectionList::replace( RT_Primitive *p1, RT_Primitive *p2 ) {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do 	{
	RT_InterSection *is = (RT_InterSection *)tmp->elem;
	if (is->prim == p1) is->prim = p2;
    }
    while (tmp = tmp->next);
}

RT_InterSection *RT_InterSectionList::first() const { 
    return root && root->elem ? (RT_InterSection*)root->elem : 0; 
}

RT_InterSection *RT_InterSectionList::second() const {
    return root && root->next && root->next->elem ? (RT_InterSection*)root->next->elem : 0; 
}

