#ifndef __INTERSECT_H__
#define __INTERSECT_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of Intersection Class and -list.                               //  
//  LAST EDIT: Fri Aug  5 08:55:19 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rlist.h"
#include "primitiv.h"
#include "surface.h"

extern const char *RTN_INTER_SECTION;

class RT_InterSection: public RT_GeneralListEntry {
friend class RT_InterSectionList;
    RT_Primitive *prim;
    RT_Surface *surf;
    // the surface properties at the intersection point
    double t; 
    // the line parameter at intersection: ray.pt + t * ray.dir
  public:
    RT_InterSection() { prim = 0; surf = 0; }
    RT_InterSection(RT_Primitive *_prim, double _t, int e, const RT_Surface *_surf ) {
	surf = new RT_Surface;
	*surf = *_surf;
	prim = _prim; t = _t; enter = e;
    }
    ~RT_InterSection() { if (surf) delete surf; }

    double getT() { return t; }
    RT_Surface *getSurface() { return surf; }
    RT_Primitive *getPrim() { return prim; }
    int enter; // 1 if entering, 0 if exiting

    int operator < (RT_InterSection &);

    void print(FILE *f) const {
	fprintf( f, "%s: Object: %s, t: %f, %s\n", RTN_INTER_SECTION, prim->get_name(), t, enter ? "entering" : "exiting" );
    }

    int isA(const char *_c) const { return RTM_isA( _c, RTN_INTER_SECTION ); }
};

class RT_InterSectionList:public RT_GeneralList {
    int nr;
    void sort();
    // sort the list
  public:
    RT_InterSectionList() { nr = 0; }
    ~RT_InterSectionList() {
	RT_GeneralListElem *tmp;
	if (tmp = root) {
	    do delete tmp->elem;
	    while(tmp = tmp->next);
	}
    }

    RT_InterSection *first() const;
    // return first intersection
    RT_InterSection *second() const;
    // return second intersection

    void add(RT_InterSection *s) { append( s ); nr++; sort(); }
    // replace all p1 with p2:
    void replace( RT_Primitive *p1, RT_Primitive *p2 );
};

#endif

